/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PersistentFileSetManager
implements PersistentStateComponent<Element> {
    private static final String FILE_ELEMENT = "file";
    private static final String PATH_ATTR = "url";
    private final Set<VirtualFile> myFiles = new HashSet();

    protected boolean addFile(VirtualFile file) {
        if (!(file instanceof VirtualFileWithId) || file.isDirectory()) {
            return false;
        }
        this.myFiles.add(file);
        return true;
    }

    protected boolean containsFile(VirtualFile file) {
        return this.myFiles.contains(file);
    }

    protected boolean removeFile(VirtualFile file) {
        if (!this.myFiles.contains(file)) {
            return false;
        }
        this.myFiles.remove(file);
        return true;
    }

    @NotNull
    public Collection<VirtualFile> getFiles() {
        Set<VirtualFile> set = this.myFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/file/exclude/PersistentFileSetManager", "getFiles"));
        }
        return set;
    }

    public Collection<VirtualFile> getSortedFiles() {
        ArrayList<VirtualFile> sortedFiles = new ArrayList<VirtualFile>();
        sortedFiles.addAll(this.myFiles);
        Collections.sort(sortedFiles, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile file1, VirtualFile file2) {
                return file1.getPath().toLowerCase().compareTo(file2.getPath().toLowerCase());
            }
        });
        return sortedFiles;
    }

    public Element getState() {
        Element root = new Element("root");
        for (VirtualFile vf : this.getSortedFiles()) {
            Element vfElement = new Element(FILE_ELEMENT);
            Attribute filePathAttr = new Attribute(PATH_ATTR, VfsUtilCore.pathToUrl((String)vf.getPath()));
            vfElement.setAttribute(filePathAttr);
            root.addContent(vfElement);
        }
        return root;
    }

    public void loadState(Element state2) {
        VirtualFileManager vfManager = VirtualFileManager.getInstance();
        for (Element child : state2.getChildren(FILE_ELEMENT)) {
            String filePath;
            VirtualFile vf;
            Element fileElement;
            Attribute filePathAttr;
            if (!(child instanceof Element) || (filePathAttr = (fileElement = child).getAttribute(PATH_ATTR)) == null || (vf = vfManager.findFileByUrl(filePath = filePathAttr.getValue())) == null) continue;
            this.myFiles.add(vf);
        }
    }
}

