/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import java.util.List;

public class MappingUtil {
    private MappingUtil() {
    }

    public static int getCacheEntryIndexForOffset(int offset, Document document, List<CacheEntry> cache) {
        if (offset >= document.getTextLength() && (cache.isEmpty() || cache.get((int)(cache.size() - 1)).endOffset < offset)) {
            return -(cache.size() + 1);
        }
        int start = 0;
        int end = cache.size() - 1;
        while (start <= end) {
            int i = end + start >>> 1;
            CacheEntry cacheEntry = cache.get(i);
            if (cacheEntry.endOffset < offset) {
                start = i + 1;
                continue;
            }
            if (cacheEntry.startOffset > offset) {
                end = i - 1;
                continue;
            }
            if (offset == cacheEntry.endOffset && i < cache.size() - 1) {
                CacheEntry nextLineCacheEntry = cache.get(i + 1);
                if (nextLineCacheEntry.startOffset == offset) {
                    return i + 1;
                }
            }
            return i;
        }
        return -(start + 1);
    }
}

