/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import org.jetbrains.annotations.NotNull;

public class IncrementalCacheUpdateEvent {
    private final int myStartLogicalLine;
    private final int myExactStartOffset;
    private final int myOldExactEndOffset;
    private final int myOldStartOffset;
    private final int myOldEndOffset;
    private final int myOldLogicalLinesDiff;
    private final int myNewExactEndOffset;
    private int myNewStartOffset;
    private int myNewEndOffset;
    private int myNewLogicalLinesDiff;

    public IncrementalCacheUpdateEvent(@NotNull DocumentEvent event, @NotNull Editor editor) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this(editor, event.getOffset(), event.getOffset() + event.getOldLength(), event.getOffset() + event.getNewLength());
    }

    public IncrementalCacheUpdateEvent(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this(editor, startOffset, endOffset, endOffset);
    }

    private IncrementalCacheUpdateEvent(@NotNull Editor editor, int startOffset, int oldEndOffset, int newEndOffset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        Document document = editor.getDocument();
        this.myExactStartOffset = startOffset;
        this.myOldExactEndOffset = oldEndOffset;
        this.myNewExactEndOffset = newEndOffset;
        this.myStartLogicalLine = IncrementalCacheUpdateEvent.getLine(this.myExactStartOffset, document);
        this.myOldLogicalLinesDiff = IncrementalCacheUpdateEvent.getLine(this.myOldExactEndOffset, document) - this.myStartLogicalLine;
        this.myOldStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor, this.myExactStartOffset);
        this.myOldEndOffset = EditorUtil.getNotFoldedLineEndOffset(editor, this.myOldExactEndOffset);
    }

    public IncrementalCacheUpdateEvent(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this(document, 0, Math.max(0, document.getTextLength() - 1));
    }

    public IncrementalCacheUpdateEvent(@NotNull Document document, int exactStartOffset, int exactEndOffset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this.myOldStartOffset = this.myExactStartOffset = exactStartOffset;
        this.myOldExactEndOffset = this.myNewExactEndOffset = exactEndOffset;
        this.myOldEndOffset = this.myNewExactEndOffset;
        this.myStartLogicalLine = IncrementalCacheUpdateEvent.getLine(this.myExactStartOffset, document);
        this.myOldLogicalLinesDiff = IncrementalCacheUpdateEvent.getLine(this.myOldExactEndOffset, document) - this.myStartLogicalLine;
    }

    public void updateNewOffsetsIfNecessary(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "updateNewOffsetsIfNecessary"));
        }
        Document document = editor.getDocument();
        this.myNewLogicalLinesDiff = document.getLineNumber(this.myNewExactEndOffset) - document.getLineNumber(this.myExactStartOffset);
        this.myNewStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor, this.myExactStartOffset);
        this.myNewEndOffset = EditorUtil.getNotFoldedLineEndOffset(editor, this.myNewExactEndOffset);
    }

    public int getExactOffsetsDiff() {
        return this.myNewExactEndOffset - this.myOldExactEndOffset;
    }

    public int getStartLogicalLine() {
        return this.myStartLogicalLine;
    }

    public int getOldExactStartOffset() {
        return this.myExactStartOffset;
    }

    public int getOldExactEndOffset() {
        return this.myOldExactEndOffset;
    }

    public int getOldStartOffset() {
        return this.myOldStartOffset;
    }

    public int getOldEndOffset() {
        return this.myOldEndOffset;
    }

    public int getOldLogicalLinesDiff() {
        return this.myOldLogicalLinesDiff;
    }

    public int getOldEndLogicalLine() {
        return this.myStartLogicalLine + this.myOldLogicalLinesDiff;
    }

    public int getNewStartOffset() {
        return this.myNewStartOffset;
    }

    public int getNewEndOffset() {
        return this.myNewEndOffset;
    }

    public int getNewLogicalLinesDiff() {
        return this.myNewLogicalLinesDiff;
    }

    private static int getLine(int offset, Document document) {
        if (offset >= document.getTextLength()) {
            int result = document.getLineCount();
            return result > 0 ? result - 1 : 0;
        }
        return document.getLineNumber(offset);
    }

    public String toString() {
        return String.format("exact old offsets: %d-%d; recalculation old offsets: %d-%d; exact new offsets: %d-%d; recalculation new offsets: %d-%d; old logical lines diff: %d; new logical lines diff: %d; offset diff: %d", this.myExactStartOffset, this.myOldExactEndOffset, this.myOldStartOffset, this.myOldEndOffset, this.myExactStartOffset, this.myNewExactEndOffset, this.myNewStartOffset, this.myNewEndOffset, this.getOldLogicalLinesDiff(), this.getNewLogicalLinesDiff(), this.getExactOffsetsDiff());
    }
}

