/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import org.jetbrains.annotations.NotNull;

class EditorPosition
implements Cloneable {
    public int logicalLine;
    public int logicalColumn;
    public int visualLine;
    public int visualColumn;
    public int offset;
    public int softWrapLinesBefore;
    public int softWrapLinesCurrent;
    public int softWrapColumnDiff;
    public int foldedLines;
    public int foldingColumnDiff;
    public int x;
    public char symbol;
    public int symbolWidthInColumns;
    public int symbolWidthInPixels;
    private final Editor myEditor;

    EditorPosition(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "<init>"));
        }
        this.myEditor = editor;
    }

    EditorPosition(@NotNull LogicalPosition logical, int offset, @NotNull Editor editor) {
        if (logical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logical", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "<init>"));
        }
        this(logical, logical.toVisualPosition(), offset, editor);
    }

    EditorPosition(@NotNull LogicalPosition logical, @NotNull VisualPosition visual, int offset, @NotNull Editor editor) {
        if (logical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logical", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "<init>"));
        }
        if (visual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visual", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "<init>"));
        }
        this.myEditor = editor;
        this.logicalLine = logical.line;
        this.logicalColumn = logical.column;
        this.softWrapLinesBefore = logical.softWrapLinesBeforeCurrentLogicalLine;
        this.softWrapLinesCurrent = logical.softWrapLinesOnCurrentLogicalLine;
        this.softWrapColumnDiff = logical.softWrapColumnDiff;
        this.foldedLines = logical.foldedLines;
        this.foldingColumnDiff = logical.foldingColumnDiff;
        this.visualLine = visual.line;
        this.visualColumn = visual.column;
        this.offset = offset;
    }

    @NotNull
    public LogicalPosition buildLogicalPosition() {
        LogicalPosition logicalPosition = new LogicalPosition(this.logicalLine, this.logicalColumn, this.softWrapLinesBefore, this.softWrapLinesCurrent, this.softWrapColumnDiff, this.foldedLines, this.foldingColumnDiff);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "buildLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition buildVisualPosition() {
        VisualPosition visualPosition = new VisualPosition(this.visualLine, this.visualColumn);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "buildVisualPosition"));
        }
        return visualPosition;
    }

    public void onNewLine(boolean softWrapAware) {
        if (!softWrapAware || this.myEditor.getSoftWrapModel().getSoftWrap(this.offset) == null) {
            this.onNewLine();
            return;
        }
        ++this.softWrapLinesCurrent;
        this.softWrapColumnDiff = -this.logicalColumn - this.foldingColumnDiff;
        ++this.visualLine;
        this.visualColumn = 0;
        this.x = 0;
    }

    public void onNewLine() {
        this.softWrapLinesBefore += this.softWrapLinesCurrent;
        this.softWrapLinesCurrent = 0;
        this.softWrapColumnDiff = 0;
        this.foldingColumnDiff = 0;
        ++this.visualLine;
        this.visualColumn = 0;
        ++this.logicalLine;
        this.logicalColumn = 0;
        this.x = 0;
        ++this.offset;
    }

    public void advance(@NotNull FoldRegion foldRegion, int collapsedSymbolsWidthInColumns) {
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "advance"));
        }
        String placeholder = foldRegion.getPlaceholderText();
        this.visualColumn += placeholder.length();
        this.offset = foldRegion.getEndOffset();
        Document document = this.myEditor.getDocument();
        int endOffsetLogicalLine = document.getLineNumber(foldRegion.getEndOffset());
        if (this.logicalLine == endOffsetLogicalLine) {
            if (collapsedSymbolsWidthInColumns < 0) {
                collapsedSymbolsWidthInColumns = SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor).toVisualColumnSymbolsNumber(document.getCharsSequence(), foldRegion.getStartOffset(), foldRegion.getEndOffset(), this.x);
            }
            this.logicalColumn += collapsedSymbolsWidthInColumns;
            this.foldingColumnDiff += placeholder.length() - collapsedSymbolsWidthInColumns;
        } else {
            if (collapsedSymbolsWidthInColumns < 0) {
                collapsedSymbolsWidthInColumns = SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor).toVisualColumnSymbolsNumber(document.getCharsSequence(), foldRegion.getStartOffset(), foldRegion.getEndOffset(), 0);
            }
            int linesDiff = endOffsetLogicalLine - this.logicalLine;
            this.logicalLine += linesDiff;
            this.foldedLines += linesDiff;
            this.logicalColumn = collapsedSymbolsWidthInColumns;
            this.foldingColumnDiff = this.visualColumn - this.logicalColumn - this.softWrapColumnDiff;
        }
    }

    public void from(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition", "from"));
        }
        this.logicalLine = position.logicalLine;
        this.logicalColumn = position.logicalColumn;
        this.visualLine = position.visualLine;
        this.visualColumn = position.visualColumn;
        this.offset = position.offset;
        this.softWrapLinesBefore = position.softWrapLinesBefore;
        this.softWrapLinesCurrent = position.softWrapLinesCurrent;
        this.softWrapColumnDiff = position.softWrapColumnDiff;
        this.foldedLines = position.foldedLines;
        this.foldingColumnDiff = position.foldingColumnDiff;
        this.x = position.x;
        this.symbol = position.symbol;
        this.symbolWidthInColumns = position.symbolWidthInColumns;
        this.symbolWidthInPixels = position.symbolWidthInPixels;
    }

    protected EditorPosition clone() {
        EditorPosition result = new EditorPosition(this.myEditor);
        result.logicalLine = this.logicalLine;
        result.logicalColumn = this.logicalColumn;
        result.visualLine = this.visualLine;
        result.visualColumn = this.visualColumn;
        result.offset = this.offset;
        result.softWrapLinesBefore = this.softWrapLinesBefore;
        result.softWrapLinesCurrent = this.softWrapLinesCurrent;
        result.softWrapColumnDiff = this.softWrapColumnDiff;
        result.foldedLines = this.foldedLines;
        result.foldingColumnDiff = this.foldingColumnDiff;
        result.x = this.x;
        result.symbol = this.symbol;
        result.symbolWidthInColumns = this.symbolWidthInColumns;
        result.symbolWidthInPixels = this.symbolWidthInPixels;
        return result;
    }

    public String toString() {
        return String.format("visual position: (%d; %d); logical position: (%d; %d); offset: %d; soft wraps: before=%d, current=%d, column diff=%d; fold regions: lines=%d, column diff=%d", this.visualLine, this.visualColumn, this.logicalLine, this.logicalColumn, this.offset, this.softWrapLinesBefore, this.softWrapLinesCurrent, this.softWrapColumnDiff, this.foldedLines, this.foldingColumnDiff);
    }
}

