/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;

public abstract class LineOrientedDocumentChangeAdapter
implements PrioritizedDocumentListener {
    public void beforeDocumentChange(DocumentEvent event) {
        Document document = event.getDocument();
        int startLine = document.getLineNumber(LineOrientedDocumentChangeAdapter.normalize(event.getDocument(), event.getOffset()));
        int endLine = document.getLineNumber(LineOrientedDocumentChangeAdapter.normalize(event.getDocument(), event.getOffset() + event.getOldLength()));
        int symbolsDifference = event.getNewLength() - event.getOldLength();
        this.beforeDocumentChange(startLine, endLine, symbolsDifference);
    }

    public void documentChanged(DocumentEvent event) {
        Document document = event.getDocument();
        int startLine = document.getLineNumber(LineOrientedDocumentChangeAdapter.normalize(event.getDocument(), event.getOffset()));
        int endLine = document.getLineNumber(LineOrientedDocumentChangeAdapter.normalize(event.getDocument(), event.getOffset() + event.getNewLength()));
        int symbolsDifference = event.getNewLength() - event.getOldLength();
        this.afterDocumentChange(startLine, endLine, symbolsDifference);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public abstract void beforeDocumentChange(int var1, int var2, int var3);

    public abstract void afterDocumentChange(int var1, int var2, int var3);

    private static int normalize(Document document, int offset) {
        if (offset < 0) {
            return 0;
        }
        if (offset >= document.getTextLength()) {
            return Math.max(document.getTextLength() - 1, 0);
        }
        return offset;
    }
}

