/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.Consumer;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RangeHighlighterData {
    private final MarkupModel myModel;
    private TextAttributes myTextAttributes;
    private LineMarkerRenderer myLineMarkerRenderer;
    private Color myErrorStripeColor;
    private Color myLineSeparatorColor;
    private SeparatorPlacement mySeparatorPlacement;
    private GutterIconRenderer myGutterIconRenderer;
    private Object myErrorStripeTooltip;
    private MarkupEditorFilter myFilter;
    private CustomHighlighterRenderer myCustomRenderer;
    int myLine;
    private LineSeparatorRenderer myLineSeparatorRenderer;
    private byte myFlags;
    private static final int AFTER_END_OF_LINE_FLAG = 0;
    private static final int ERROR_STRIPE_IS_THIN_FLAG = 1;
    private static final int TARGET_AREA_IS_EXACT_FLAG = 2;
    private static final int IN_BATCH_CHANGE_FLAG = 3;
    private static final int CHANGED_FLAG = 4;
    private static final int RENDERERS_CHANGED_FLAG = 5;

    RangeHighlighterData(@NotNull MarkupModel model, @NotNull HighlighterTargetArea target, TextAttributes textAttributes) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/editor/impl/RangeHighlighterData", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/openapi/editor/impl/RangeHighlighterData", "<init>"));
        }
        this.myFilter = MarkupEditorFilter.EMPTY;
        this.myTextAttributes = textAttributes;
        this.setFlag(2, target == HighlighterTargetArea.EXACT_RANGE);
        this.myModel = model;
        if (textAttributes != null) {
            this.myErrorStripeColor = textAttributes.getErrorStripeColor();
        }
    }

    private boolean isFlagSet(@FlagConstant int flag) {
        int state2 = this.myFlags >> flag;
        return (state2 & 1) != 0;
    }

    private void setFlag(@FlagConstant int flag, boolean value) {
        assert (flag < 8);
        int state2 = value ? 1 : 0;
        this.myFlags = (byte)(this.myFlags & ~(1 << flag) | state2 << flag);
    }

    @NotNull
    public abstract RangeHighlighterEx getRangeHighlighter();

    public TextAttributes getTextAttributes() {
        return this.myTextAttributes;
    }

    public void setTextAttributes(TextAttributes textAttributes) {
        TextAttributes old = this.myTextAttributes;
        this.myTextAttributes = textAttributes;
        if (!Comparing.equal((Object)old, (Object)textAttributes)) {
            this.fireChanged(false);
        }
    }

    @NotNull
    public HighlighterTargetArea getTargetArea() {
        HighlighterTargetArea highlighterTargetArea = this.isFlagSet(2) ? HighlighterTargetArea.EXACT_RANGE : HighlighterTargetArea.LINES_IN_RANGE;
        if (highlighterTargetArea == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterData", "getTargetArea"));
        }
        return highlighterTargetArea;
    }

    public LineMarkerRenderer getLineMarkerRenderer() {
        return this.myLineMarkerRenderer;
    }

    public void setLineMarkerRenderer(LineMarkerRenderer renderer) {
        LineMarkerRenderer old = this.myLineMarkerRenderer;
        this.myLineMarkerRenderer = renderer;
        if (!Comparing.equal((Object)old, (Object)renderer)) {
            this.fireChanged(true);
        }
    }

    public CustomHighlighterRenderer getCustomRenderer() {
        return this.myCustomRenderer;
    }

    public void setCustomRenderer(CustomHighlighterRenderer renderer) {
        CustomHighlighterRenderer old = this.myCustomRenderer;
        this.myCustomRenderer = renderer;
        if (!Comparing.equal((Object)old, (Object)renderer)) {
            this.fireChanged(true);
        }
    }

    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    public void setGutterIconRenderer(GutterIconRenderer renderer) {
        GutterIconRenderer old = this.myGutterIconRenderer;
        this.myGutterIconRenderer = renderer;
        if (!Comparing.equal((Object)old, (Object)renderer)) {
            this.fireChanged(true);
        }
    }

    public Color getErrorStripeMarkColor() {
        return this.myErrorStripeColor;
    }

    public void setErrorStripeMarkColor(Color color) {
        Color old = this.myErrorStripeColor;
        this.myErrorStripeColor = color;
        if (!Comparing.equal((Object)old, (Object)color)) {
            this.fireChanged(false);
        }
    }

    public Object getErrorStripeTooltip() {
        return this.myErrorStripeTooltip;
    }

    public void setErrorStripeTooltip(Object tooltipObject) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object old = this.myErrorStripeTooltip;
        this.myErrorStripeTooltip = tooltipObject;
        if (!Comparing.equal((Object)old, (Object)tooltipObject)) {
            this.fireChanged(false);
        }
    }

    public boolean isThinErrorStripeMark() {
        return this.isFlagSet(1);
    }

    public void setThinErrorStripeMark(boolean value) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean old = this.isThinErrorStripeMark();
        this.setFlag(1, value);
        if (old != value) {
            this.fireChanged(false);
        }
    }

    public Color getLineSeparatorColor() {
        return this.myLineSeparatorColor;
    }

    public void setLineSeparatorColor(Color color) {
        Color old = this.myLineSeparatorColor;
        this.myLineSeparatorColor = color;
        if (!Comparing.equal((Object)old, (Object)color)) {
            this.fireChanged(false);
        }
    }

    public SeparatorPlacement getLineSeparatorPlacement() {
        return this.mySeparatorPlacement;
    }

    public void setLineSeparatorPlacement(@Nullable SeparatorPlacement placement) {
        SeparatorPlacement old = this.mySeparatorPlacement;
        this.mySeparatorPlacement = placement;
        if (!Comparing.equal((Object)old, (Object)placement)) {
            this.fireChanged(false);
        }
    }

    public void setEditorFilter(@NotNull MarkupEditorFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/openapi/editor/impl/RangeHighlighterData", "setEditorFilter"));
        }
        this.myFilter = filter;
        this.fireChanged(false);
    }

    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = this.myFilter;
        if (markupEditorFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterData", "getEditorFilter"));
        }
        return markupEditorFilter;
    }

    public boolean isAfterEndOfLine() {
        return this.isFlagSet(0);
    }

    public void setAfterEndOfLine(boolean afterEndOfLine) {
        boolean old = this.isAfterEndOfLine();
        this.setFlag(0, afterEndOfLine);
        if (old != afterEndOfLine) {
            this.fireChanged(false);
        }
    }

    private void fireChanged(boolean renderersChanged) {
        if (this.myModel instanceof MarkupModelEx) {
            if (this.isFlagSet(3)) {
                this.setFlag(4, true);
                if (renderersChanged) {
                    this.setFlag(5, true);
                }
            } else {
                ((MarkupModelEx)this.myModel).fireAttributesChanged(this.getRangeHighlighter(), renderersChanged);
            }
        }
    }

    public int getAffectedAreaStartOffset() {
        int startOffset = this.getRangeHighlighter().getStartOffset();
        if (this.getTargetArea() == HighlighterTargetArea.EXACT_RANGE) {
            return startOffset;
        }
        Document document = this.myModel.getDocument();
        int textLength = document.getTextLength();
        if (startOffset >= textLength) {
            return textLength;
        }
        return document.getLineStartOffset(document.getLineNumber(startOffset));
    }

    public int getAffectedAreaEndOffset() {
        int endOffset = this.getRangeHighlighter().getEndOffset();
        if (this.getTargetArea() == HighlighterTargetArea.EXACT_RANGE) {
            return endOffset;
        }
        Document document = this.myModel.getDocument();
        int textLength = document.getTextLength();
        if (endOffset >= textLength) {
            return endOffset;
        }
        return Math.min(textLength, document.getLineEndOffset(document.getLineNumber(endOffset)) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    ChangeResult changeAttributesInBatch(@NotNull Consumer<RangeHighlighterEx> change) {
        ChangeResult changeResult;
        block7: {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/editor/impl/RangeHighlighterData", "changeAttributesInBatch"));
            }
            assert (!this.isFlagSet(3));
            assert (!this.isFlagSet(4));
            this.setFlag(3, true);
            this.setFlag(5, false);
            try {
                change.consume((Object)this.getRangeHighlighter());
                this.setFlag(3, false);
                boolean changed = this.isFlagSet(4);
                boolean renderersChanged = this.isFlagSet(5);
                if (changed) {
                    changeResult = renderersChanged ? ChangeResult.RENDERERS_CHANGED : ChangeResult.MINOR_CHANGE;
                    break block7;
                }
                changeResult = ChangeResult.NOT_CHANGED;
            }
            catch (Throwable throwable) {
                this.setFlag(3, false);
                boolean changed = this.isFlagSet(4);
                boolean renderersChanged = this.isFlagSet(5);
                ChangeResult result = changed ? (renderersChanged ? ChangeResult.RENDERERS_CHANGED : ChangeResult.MINOR_CHANGE) : ChangeResult.NOT_CHANGED;
                this.setFlag(4, false);
                this.setFlag(5, false);
                throw throwable;
            }
        }
        ChangeResult result = changeResult;
        this.setFlag(4, false);
        this.setFlag(5, false);
        ChangeResult changeResult2 = result;
        if (changeResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterData", "changeAttributesInBatch"));
        }
        return changeResult2;
    }

    public MarkupModel getMarkupModel() {
        return this.myModel;
    }

    public void setLineSeparatorRenderer(LineSeparatorRenderer renderer) {
        LineSeparatorRenderer old = this.myLineSeparatorRenderer;
        this.myLineSeparatorRenderer = renderer;
        if (!Comparing.equal((Object)old, (Object)renderer)) {
            this.fireChanged(true);
        }
    }

    public LineSeparatorRenderer getLineSeparatorRenderer() {
        return this.myLineSeparatorRenderer;
    }

    static enum ChangeResult {
        NOT_CHANGED,
        MINOR_CHANGE,
        RENDERERS_CHANGED;

    }

    static @interface FlagConstant {
    }
}

