/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.DisposableIterator;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingAnchorsOverlayStrategy;
import com.intellij.openapi.editor.impl.IterationState;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntFunction;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectProcedure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorGutterComponentImpl
extends EditorGutterComponentEx
implements MouseListener,
MouseMotionListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorGutterComponentImpl");
    private static final int START_ICON_AREA_WIDTH = 15;
    private static final int FREE_PAINTERS_AREA_WIDTH = 5;
    private static final int GAP_BETWEEN_ICONS = 3;
    private static final TooltipGroup GUTTER_TOOLTIP_GROUP = new TooltipGroup("GUTTER_TOOLTIP_GROUP", 0);
    private static final Color COLOR_F0F0 = new Color(0xF0F0F0);
    public static final TIntFunction ID = new TIntFunction(){

        public int execute(int value) {
            return value;
        }
    };
    private final EditorImpl myEditor;
    private final FoldingAnchorsOverlayStrategy myAnchorsDisplayStrategy;
    private int myLineMarkerAreaWidth = 20;
    private int myIconsAreaWidth = 15;
    private int myLineNumberAreaWidth = 0;
    private FoldRegion myActiveFoldRegion;
    private boolean myPopupInvokedOnPressed;
    private int myTextAnnotationGuttersSize = 0;
    private int myTextAnnotationExtraSize = 0;
    private TIntArrayList myTextAnnotationGutterSizes = new TIntArrayList();
    private ArrayList<TextAnnotationGutterProvider> myTextAnnotationGutters = new ArrayList();
    private final Map<TextAnnotationGutterProvider, EditorGutterAction> myProviderToListener = new HashMap();
    private static final int GAP_BETWEEN_ANNOTATIONS = 6;
    private Color myBackgroundColor = null;
    private String myLastGutterToolTip = null;
    private int myLastPreferredHeight = -1;
    @NotNull
    private TIntFunction myLineNumberConvertor;
    private boolean myShowDefaultGutterPopup = true;
    private TIntObjectHashMap<List<GutterMark>> myLineToGutterRenderers;

    public EditorGutterComponentImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myLineNumberConvertor = ID;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.installDnD();
        }
        this.setOpaque(true);
        this.myAnchorsDisplayStrategy = new FoldingAnchorsOverlayStrategy(editor);
    }

    private void installDnD() {
        DnDSupport.createBuilder((JComponent)this).setBeanProvider((Function)new Function<DnDActionInfo, DnDDragStartBean>(){

            public DnDDragStartBean fun(DnDActionInfo info) {
                GutterMark renderer = EditorGutterComponentImpl.this.getGutterRenderer(info.getPoint());
                return renderer != null && (info.isCopy() || info.isMove()) ? new DnDDragStartBean((Object)renderer) : null;
            }
        }).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent e) {
                int line;
                GutterDraggableObject draggableObject;
                Object attachedObject = e.getAttachedObject();
                if (attachedObject instanceof GutterIconRenderer && (draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject()) != null && (line = EditorGutterComponentImpl.this.convertPointToLineNumber(e.getPoint())) != -1) {
                    draggableObject.copy(line, EditorGutterComponentImpl.this.myEditor.getVirtualFile());
                }
            }
        }).setImageProvider((Function)new NullableFunction<DnDActionInfo, DnDImage>(){

            public DnDImage fun(DnDActionInfo info) {
                return new DnDImage(IconUtil.toImage((Icon)EditorGutterComponentImpl.this.getGutterRenderer(info.getPoint()).getIcon()));
            }
        }).install();
    }

    private void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.getLineNumberAreaWidth() + this.getAnnotationsAreaWidthEx() + this.getLineMarkerAreaWidth() + this.getFoldingAreaWidth();
        return new Dimension(w, this.myLastPreferredHeight);
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.reinitSettings();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.reinitSettings();
    }

    public void reinitSettings() {
        this.myBackgroundColor = null;
        this.revalidateMarkup();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
        try {
            Rectangle clip = g.getClipBounds();
            if (clip.height < 0) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform old = g2.getTransform();
            if (this.isMirrored()) {
                AffineTransform transform = new AffineTransform(old);
                transform.scale(-1.0, 1.0);
                transform.translate(-this.getWidth(), 0.0);
                g2.setTransform(transform);
            }
            UISettings.setupAntialiasing((Graphics)g);
            this.paintLineNumbersBackground(g, clip);
            this.paintAnnotations(g, clip);
            Object hint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (!UIUtil.isRetina()) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            try {
                int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
                int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
                this.paintFoldingBackground(g, clip);
                this.paintFoldingLines((Graphics2D)g, clip);
                this.paintLineMarkers(g, clip, firstVisibleOffset, lastVisibleOffset);
                this.paintEditorBackgrounds(g, clip, firstVisibleOffset, lastVisibleOffset);
                this.paintFoldingTree(g, clip, firstVisibleOffset, lastVisibleOffset);
                this.paintLineNumbers(g, clip);
            }
            finally {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
            }
            g2.setTransform(old);
        }
        finally {
            ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
        }
    }

    private void paintEditorBackgrounds(Graphics g, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        Color defaultBackgroundColor = this.myEditor.getBackgroundColor();
        int startX = this.getWhitespaceSeparatorOffset() + 1;
        IterationState state2 = new IterationState(this.myEditor, firstVisibleOffset, lastVisibleOffset, false, true);
        while (!state2.atEnd()) {
            VisualPosition visualStart = this.myEditor.offsetToVisualPosition(state2.getStartOffset());
            VisualPosition visualEnd = this.myEditor.offsetToVisualPosition(state2.getEndOffset());
            for (int line = visualStart.getLine(); line <= visualEnd.getLine(); ++line) {
                if (line == visualStart.getLine()) {
                    if (visualStart.getColumn() != 0) continue;
                    this.drawEditorLineBackgroundRect(g, clip, state2, defaultBackgroundColor, startX, this.myEditor.visibleLineToY(line));
                    continue;
                }
                if (line == visualEnd.getLine() && visualEnd.getColumn() == 0) continue;
                this.drawEditorLineBackgroundRect(g, clip, state2, defaultBackgroundColor, startX, this.myEditor.visibleLineToY(line));
            }
            state2.advance();
        }
    }

    private void drawEditorLineBackgroundRect(Graphics g, Rectangle clip, IterationState state2, Color defaultBackgroundColor, int startX, int startY) {
        Color color = this.myEditor.getBackgroundColor(state2.getMergedAttributes());
        if (!color.equals(defaultBackgroundColor)) {
            g.setColor(color);
            g.fillRect(startX, startY, clip.width - startX, this.myEditor.getLineHeight());
        }
    }

    private void processClose(MouseEvent e) {
        IdeEventQueue queue = IdeEventQueue.getInstance();
        if (this.getGutterRenderer(e) != null) {
            return;
        }
        int x = this.getAnnotationsAreaOffset();
        for (int i = 0; i < this.myTextAnnotationGutters.size(); ++i) {
            int size = this.myTextAnnotationGutterSizes.get(i);
            if (x <= e.getX() && e.getX() <= x + size + 6) {
                queue.blockNextEvents(e);
                this.closeAllAnnotations();
                e.consume();
                break;
            }
            x += size + 6;
        }
    }

    private void paintAnnotations(Graphics g, Rectangle clip) {
        int x = this.getAnnotationsAreaOffset();
        int w = this.getAnnotationsAreaWidthEx();
        if (w == 0) {
            return;
        }
        Color background = this.myEditor.isInDistractionFreeMode() ? this.myEditor.getBackgroundColor() : this.getBackground();
        this.paintBackground(g, clip, this.getAnnotationsAreaOffset(), w, background);
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.ANNOTATIONS_COLOR);
        g.setColor(color != null ? color : JBColor.blue);
        g.setFont(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        for (int i = 0; i < this.myTextAnnotationGutters.size(); ++i) {
            TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(i);
            int lineHeight = this.myEditor.getLineHeight();
            int startLineNumber = clip.y / lineHeight;
            int endLineNumber = (clip.y + clip.height) / lineHeight + 1;
            int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line;
            if (startLineNumber >= (endLineNumber = Math.min(endLineNumber, lastLine + 1))) break;
            for (int j = startLineNumber; j < endLineNumber; ++j) {
                int logLine = this.myEditor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)j, (int)0)).line;
                String s = gutterProvider.getLineText(logLine, (Editor)this.myEditor);
                EditorFontType style = gutterProvider.getStyle(logLine, (Editor)this.myEditor);
                Color bg = gutterProvider.getBgColor(logLine, (Editor)this.myEditor);
                if (bg != null) {
                    g.setColor(bg);
                    g.fillRect(x, j * lineHeight, w, lineHeight);
                }
                g.setColor(this.myEditor.getColorsScheme().getColor(gutterProvider.getColor(logLine, (Editor)this.myEditor)));
                g.setFont(this.myEditor.getColorsScheme().getFont(style));
                if (s == null) continue;
                g.drawString(s, x, (j + 1) * lineHeight - this.myEditor.getDescent());
            }
            x += this.myTextAnnotationGutterSizes.get(i);
        }
        if (!this.myEditor.isInDistractionFreeMode()) {
            UIUtil.drawVDottedLine((Graphics2D)((Graphics2D)g), (int)(this.getAnnotationsAreaOffset() + w - 1), (int)clip.y, (int)(clip.y + clip.height), null, (Color)this.getOutlineColor(false));
        }
    }

    private void paintFoldingTree(Graphics g, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        if (this.isFoldingOutlineShown()) {
            this.doPaintFoldingTree((Graphics2D)g, clip, firstVisibleOffset, lastVisibleOffset);
        } else {
            UIUtil.drawVDottedLine((Graphics2D)((Graphics2D)g), (int)(clip.x + clip.width - 1), (int)clip.y, (int)(clip.y + clip.height), null, (Color)this.getOutlineColor(false));
        }
    }

    private void paintLineMarkers(Graphics g, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        if (this.isLineMarkersShown()) {
            this.paintBackground(g, clip, this.getLineMarkerAreaOffset(), this.getLineMarkerAreaWidth());
            this.paintGutterRenderers(g, firstVisibleOffset, lastVisibleOffset);
        }
    }

    private void paintBackground(Graphics g, Rectangle clip, int x, int width) {
        this.paintBackground(g, clip, x, width, this.getBackground());
    }

    private void paintBackground(Graphics g, Rectangle clip, int x, int width, Color background) {
        g.setColor(background);
        g.fillRect(x, clip.y, width, clip.height);
        this.paintCaretRowBackground(g, x, width);
    }

    private void paintCaretRowBackground(Graphics g, int x, int width) {
        VisualPosition visCaret = this.myEditor.getCaretModel().getVisualPosition();
        Color caretRowColor = this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
        if (caretRowColor != null) {
            g.setColor(caretRowColor);
            Point caretPoint = this.myEditor.visualPositionToXY(visCaret);
            g.fillRect(x, caretPoint.y, width, this.myEditor.getLineHeight());
        }
    }

    private void paintLineNumbers(Graphics g, Rectangle clip) {
        if (this.isLineNumbersShown()) {
            int x = EditorGutterComponentImpl.getLineNumberAreaOffset() + this.getLineNumberAreaWidth() - 2;
            UIUtil.drawVDottedLine((Graphics2D)((Graphics2D)g), (int)x, (int)clip.y, (int)(clip.y + clip.height), null, (Color)this.getOutlineColor(false));
            this.doPaintLineNumbers(g, clip);
        }
    }

    private void paintLineNumbersBackground(Graphics g, Rectangle clip) {
        if (this.isLineNumbersShown()) {
            this.paintBackground(g, clip, EditorGutterComponentImpl.getLineNumberAreaOffset(), this.getLineNumberAreaWidth());
        }
    }

    @Override
    public Color getBackground() {
        if (this.myBackgroundColor == null) {
            EditorColorsScheme colorsScheme = this.myEditor.getColorsScheme();
            boolean distractionMode = this.myEditor.isInDistractionFreeMode();
            Color color = distractionMode ? colorsScheme.getDefaultBackground() : colorsScheme.getColor(EditorColors.GUTTER_BACKGROUND);
            this.myBackgroundColor = color == null ? COLOR_F0F0 : color;
        }
        return this.myBackgroundColor;
    }

    private void doPaintLineNumbers(Graphics g, Rectangle clip) {
        if (!this.isLineNumbersShown()) {
            return;
        }
        int lineHeight = this.myEditor.getLineHeight();
        int startLineNumber = clip.y / lineHeight;
        int endLineNumber = (clip.y + clip.height) / lineHeight + 1;
        int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line;
        if (startLineNumber >= (endLineNumber = Math.min(endLineNumber, lastLine + 1))) {
            return;
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR);
        g.setColor(color != null ? color : JBColor.blue);
        g.setFont(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform old = g2.getTransform();
        if (this.isMirrored()) {
            AffineTransform originalTransform = new AffineTransform(old);
            originalTransform.scale(-1.0, 1.0);
            originalTransform.translate(-this.getLineNumberAreaWidth() + 2, 0.0);
            g2.setTransform(originalTransform);
        }
        for (int i = startLineNumber; i < endLineNumber; ++i) {
            int logLine;
            LogicalPosition logicalPosition = this.myEditor.visualToLogicalPosition(new VisualPosition(i, 0));
            if (logicalPosition.softWrapLinesOnCurrentLogicalLine > 0 || (logLine = this.myLineNumberConvertor.execute(logicalPosition.line)) < 0) continue;
            String s = String.valueOf(logLine + 1);
            g.drawString(s, EditorGutterComponentImpl.getLineNumberAreaOffset() + this.getLineNumberAreaWidth() - this.myEditor.getFontMetrics(0).stringWidth(s) - 4, (i + 1) * lineHeight - this.myEditor.getDescent());
        }
        g2.setTransform(old);
    }

    private int endLineNumber() {
        return Math.max(0, this.myEditor.getDocument().getLineCount() - 1);
    }

    private void processRangeHighlighters(int startOffset, int endOffset, @NotNull RangeHighlighterProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "processRangeHighlighters"));
        }
        DocumentEx document = this.myEditor.getDocument();
        MarkupModelEx docMarkup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myEditor.getProject(), true);
        DisposableIterator<RangeHighlighterEx> docHighlighters = docMarkup.overlappingIterator(startOffset, endOffset);
        DisposableIterator<RangeHighlighterEx> editorHighlighters = this.myEditor.getMarkupModel().overlappingIterator(startOffset, endOffset);
        try {
            RangeHighlighterEx lastDocHighlighter = null;
            RangeHighlighterEx lastEditorHighlighter = null;
            while (true) {
                int endLineIndex;
                int startLineIndex;
                RangeHighlighterEx lowerHighlighter;
                if (lastDocHighlighter == null && docHighlighters.hasNext()) {
                    lastDocHighlighter = (RangeHighlighterEx)docHighlighters.next();
                    if (!lastDocHighlighter.isValid() || lastDocHighlighter.getAffectedAreaStartOffset() > endOffset) {
                        lastDocHighlighter = null;
                        continue;
                    }
                    if (lastDocHighlighter.getAffectedAreaEndOffset() < startOffset) {
                        lastDocHighlighter = null;
                        continue;
                    }
                }
                if (lastEditorHighlighter == null && editorHighlighters.hasNext()) {
                    lastEditorHighlighter = (RangeHighlighterEx)editorHighlighters.next();
                    if (!lastEditorHighlighter.isValid() || lastEditorHighlighter.getAffectedAreaStartOffset() > endOffset) {
                        lastEditorHighlighter = null;
                        continue;
                    }
                    if (lastEditorHighlighter.getAffectedAreaEndOffset() < startOffset) {
                        lastEditorHighlighter = null;
                        continue;
                    }
                }
                if (lastDocHighlighter == null && lastEditorHighlighter == null) {
                    return;
                }
                if (EditorGutterComponentImpl.less(lastDocHighlighter, lastEditorHighlighter)) {
                    lowerHighlighter = lastDocHighlighter;
                    lastDocHighlighter = null;
                } else {
                    lowerHighlighter = lastEditorHighlighter;
                    lastEditorHighlighter = null;
                }
                assert (lowerHighlighter != null);
                if (!lowerHighlighter.isValid() || (startLineIndex = lowerHighlighter.getDocument().getLineNumber(startOffset)) < 0 || startLineIndex >= document.getLineCount() || (endLineIndex = lowerHighlighter.getDocument().getLineNumber(endOffset)) < 0 || endLineIndex >= document.getLineCount() || !lowerHighlighter.getEditorFilter().avaliableIn((Editor)this.myEditor)) continue;
                processor.process(lowerHighlighter);
            }
        }
        finally {
            docHighlighters.dispose();
            editorHighlighters.dispose();
        }
    }

    private static boolean less(RangeHighlighter h1, RangeHighlighter h2) {
        return h1 != null && (h2 == null || h1.getStartOffset() < h2.getStartOffset());
    }

    @Override
    public void revalidateMarkup() {
        this.updateSize();
    }

    public void updateSize() {
        int prevHash = this.sizeHash();
        this.updateSizeInner();
        if (prevHash != this.sizeHash()) {
            this.fireResized();
        }
        this.repaint();
    }

    private void updateSizeInner() {
        this.myLastPreferredHeight = this.myEditor.getPreferredHeight();
        this.calcIconAreaWidth();
        this.calcAnnotationsSize();
        this.calcAnnotationExtraSize();
    }

    private int sizeHash() {
        int result = this.myLastPreferredHeight;
        result = 31 * result + this.myLineMarkerAreaWidth;
        result = 31 * result + this.myTextAnnotationGuttersSize;
        result = 31 * result + this.myTextAnnotationExtraSize;
        return result;
    }

    private void calcAnnotationsSize() {
        this.myTextAnnotationGuttersSize = 0;
        FontMetrics fontMetrics = this.myEditor.getFontMetrics(0);
        int lineCount = this.myEditor.getDocument().getLineCount();
        for (int j = 0; j < this.myTextAnnotationGutters.size(); ++j) {
            TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(j);
            int gutterSize = 0;
            for (int i = 0; i < lineCount; ++i) {
                String lineText = gutterProvider.getLineText(i, (Editor)this.myEditor);
                if (lineText == null) continue;
                gutterSize = Math.max(gutterSize, fontMetrics.stringWidth(lineText));
            }
            if (gutterSize > 0) {
                gutterSize += 6;
            }
            this.myTextAnnotationGutterSizes.set(j, gutterSize);
            this.myTextAnnotationGuttersSize += gutterSize;
        }
    }

    private void calcAnnotationExtraSize() {
        int width;
        this.myTextAnnotationExtraSize = 0;
        if (!this.myEditor.isInDistractionFreeMode() || this.isMirrored()) {
            return;
        }
        Window frame = SwingUtilities.getWindowAncestor(this.myEditor.getComponent());
        if (frame == null) {
            return;
        }
        EditorSettings settings = this.myEditor.getSettings();
        int rightMargin = settings.getRightMargin(this.myEditor.getProject());
        if (rightMargin <= 0) {
            return;
        }
        JComponent editorComponent = this.myEditor.getComponent();
        RelativePoint point = new RelativePoint((Component)editorComponent, new Point(0, 0));
        Point editorLocationInWindow = point.getPoint((Component)frame);
        int editorLocationX = (int)editorLocationInWindow.getX();
        int rightMarginX = rightMargin * EditorUtil.getSpaceWidth(0, this.myEditor) + editorLocationX;
        if (rightMarginX < (width = editorLocationX + editorComponent.getWidth()) && editorLocationX < width - rightMarginX) {
            int centeredSize = (width - rightMarginX - editorLocationX) / 2 - (this.myLineMarkerAreaWidth + this.myLineNumberAreaWidth);
            this.myTextAnnotationExtraSize = Math.max(0, centeredSize - this.myTextAnnotationGuttersSize);
        }
    }

    private void calcIconAreaWidth() {
        this.myLineToGutterRenderers = new TIntObjectHashMap();
        this.processRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), new RangeHighlighterProcessor(){

            @Override
            public void process(@NotNull RangeHighlighter highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$5", "process"));
                }
                GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
                if (renderer == null) {
                    return;
                }
                if (EditorGutterComponentImpl.this.myEditor.getFoldingModel().isOffsetCollapsed(highlighter.getStartOffset())) {
                    return;
                }
                VisualPosition visualPosition = EditorGutterComponentImpl.this.myEditor.offsetToVisualPosition(highlighter.getStartOffset());
                int line = ((LogicalPosition)EditorUtil.calcSurroundingRange((Editor)((EditorGutterComponentImpl)EditorGutterComponentImpl.this).myEditor, (VisualPosition)visualPosition, (VisualPosition)visualPosition).getFirst()).line;
                List renderers = (List)EditorGutterComponentImpl.this.myLineToGutterRenderers.get(line);
                if (renderers == null) {
                    renderers = new SmartList();
                    EditorGutterComponentImpl.this.myLineToGutterRenderers.put(line, (Object)renderers);
                }
                if (renderers.size() < 5) {
                    renderers.add(renderer);
                }
            }
        });
        this.myIconsAreaWidth = 15;
        this.myLineToGutterRenderers.forEachValue((TObjectProcedure)new TObjectProcedure<List<GutterMark>>(){

            public boolean execute(List<GutterMark> renderers) {
                int width = 1;
                for (int i = 0; i < renderers.size(); ++i) {
                    GutterMark renderer = renderers.get(i);
                    width += renderer.getIcon().getIconWidth();
                    if (i <= 0) continue;
                    width += 3;
                }
                if (EditorGutterComponentImpl.this.myIconsAreaWidth < width) {
                    EditorGutterComponentImpl.this.myIconsAreaWidth = width;
                }
                return true;
            }
        });
        this.myLineMarkerAreaWidth = this.myIconsAreaWidth + 5 + (this.isFoldingOutlineShown() ? 0 : this.getFoldingAnchorWidth() / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintGutterRenderers(final Graphics g, int firstVisibleOffset, int lastVisibleOffset) {
        Graphics2D g2 = (Graphics2D)g;
        Object hint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            this.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, new RangeHighlighterProcessor(){

                @Override
                public void process(@NotNull RangeHighlighter highlighter) {
                    if (highlighter == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$7", "process"));
                    }
                    EditorGutterComponentImpl.this.paintLineMarkerRenderer(highlighter, g);
                }
            });
        }
        finally {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }
        int firstVisibleLine = this.myEditor.getDocument().getLineNumber(firstVisibleOffset);
        int lastVisibleLine = this.myEditor.getDocument().getLineNumber(lastVisibleOffset);
        this.paintIcons(firstVisibleLine, lastVisibleLine, g);
    }

    private void paintIcons(final int firstVisibleLine, final int lastVisibleLine, final Graphics g) {
        this.myLineToGutterRenderers.forEachKey(new TIntProcedure(){

            public boolean execute(int line) {
                if (firstVisibleLine > line || lastVisibleLine < line) {
                    return true;
                }
                if (EditorGutterComponentImpl.this.isLineCollapsed(line)) {
                    return true;
                }
                List renderers = (List)EditorGutterComponentImpl.this.myLineToGutterRenderers.get(line);
                EditorGutterComponentImpl.this.paintIconRow(line, renderers, g);
                return true;
            }
        });
    }

    private boolean isLineCollapsed(int line) {
        int startOffset = this.myEditor.getDocument().getLineStartOffset(line);
        FoldRegion region = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        return region != null && region.getEndOffset() >= this.myEditor.getDocument().getLineEndOffset(line);
    }

    private void paintIconRow(int line, List<GutterMark> row, final Graphics g) {
        this.processIconsRow(line, row, new LineGutterIconRendererProcessor(){

            @Override
            public void process(int x, int y, GutterMark renderer) {
                Icon icon = renderer.getIcon();
                icon.paintIcon(EditorGutterComponentImpl.this, g, x, y);
            }
        });
    }

    private void paintLineMarkerRenderer(RangeHighlighter highlighter, Graphics g) {
        Rectangle rectangle = this.getLineRendererRectangle(highlighter);
        if (rectangle != null) {
            LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
            assert (lineMarkerRenderer != null);
            lineMarkerRenderer.paint((Editor)this.myEditor, g, rectangle);
        }
    }

    @Nullable
    private Rectangle getLineRendererRectangle(RangeHighlighter highlighter) {
        LineMarkerRenderer renderer = highlighter.getLineMarkerRenderer();
        if (renderer == null) {
            return null;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(startOffset) && this.myEditor.getFoldingModel().isOffsetCollapsed(endOffset)) {
            return null;
        }
        int startY = this.myEditor.visualPositionToXY((VisualPosition)this.myEditor.offsetToVisualPosition((int)startOffset)).y;
        int endY = this.myEditor.visualPositionToXY((VisualPosition)this.myEditor.offsetToVisualPosition((int)endOffset)).y;
        DocumentEx document = this.myEditor.getDocument();
        if (document.getLineStartOffset(document.getLineNumber(endOffset)) != endOffset) {
            endY += this.myEditor.getLineHeight();
        }
        int height = endY - startY;
        int w = 5;
        int x = this.getLineMarkerAreaOffset() + this.myIconsAreaWidth;
        return new Rectangle(x, startY, w, height);
    }

    private void processIconsRow(int line, List<GutterMark> row, LineGutterIconRendererProcessor processor) {
        Icon icon;
        int middleCount = 0;
        int middleSize = 0;
        int x = this.getLineMarkerAreaOffset() + 1;
        int y = this.myEditor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
        for (GutterMark r : row) {
            GutterIconRenderer.Alignment alignment = ((GutterIconRenderer)r).getAlignment();
            icon = r.getIcon();
            if (alignment == GutterIconRenderer.Alignment.LEFT) {
                processor.process(x, y + this.getTextAlignmentShift(icon), r);
                x += icon.getIconWidth() + 3;
                continue;
            }
            if (alignment != GutterIconRenderer.Alignment.CENTER) continue;
            ++middleCount;
            middleSize += icon.getIconWidth() + 3;
        }
        int leftSize = x - this.getLineMarkerAreaOffset();
        x = this.getLineMarkerAreaOffset() + this.myIconsAreaWidth;
        for (GutterMark r : row) {
            if (((GutterIconRenderer)r).getAlignment() != GutterIconRenderer.Alignment.RIGHT) continue;
            icon = r.getIcon();
            processor.process(x -= icon.getIconWidth(), y + this.getTextAlignmentShift(icon), r);
            x -= 3;
        }
        int rightSize = this.myIconsAreaWidth + this.getLineMarkerAreaOffset() - x;
        if (middleCount > 0) {
            x = this.getLineMarkerAreaOffset() + leftSize + (this.myIconsAreaWidth - leftSize - rightSize - (middleSize -= 3)) / 2;
            for (GutterMark r : row) {
                if (((GutterIconRenderer)r).getAlignment() != GutterIconRenderer.Alignment.CENTER) continue;
                Icon icon2 = r.getIcon();
                processor.process(x, y + this.getTextAlignmentShift(icon2), r);
                x += icon2.getIconWidth() + 3;
            }
        }
    }

    private int getTextAlignmentShift(Icon icon) {
        return (this.myEditor.getLineHeight() - icon.getIconHeight()) / 2;
    }

    @Override
    public Color getOutlineColor(boolean isActive) {
        ColorKey key = isActive ? EditorColors.SELECTED_TEARLINE_COLOR : EditorColors.TEARLINE_COLOR;
        Color color = this.myEditor.getColorsScheme().getColor(key);
        return color != null ? color : JBColor.black;
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "registerTextAnnotation"));
        }
        this.myTextAnnotationGutters.add(provider);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider, @NotNull EditorGutterAction action) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "registerTextAnnotation"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "registerTextAnnotation"));
        }
        this.myTextAnnotationGutters.add(provider);
        this.myProviderToListener.put(provider, action);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    private void doPaintFoldingTree(Graphics2D g, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        int anchorX = this.getFoldingAreaOffset();
        int width = this.getFoldingAnchorWidth();
        Collection<DisplayedFoldingAnchor> anchorsToDisplay = this.myAnchorsDisplayStrategy.getAnchorsToDisplay(firstVisibleOffset, lastVisibleOffset, this.myActiveFoldRegion);
        for (DisplayedFoldingAnchor anchor : anchorsToDisplay) {
            this.drawAnchor(width, clip, g, anchorX, anchor.visualLine, anchor.type, anchor.foldRegion == this.myActiveFoldRegion);
        }
    }

    private void paintFoldingBackground(Graphics g, Rectangle clip) {
        int lineX = this.getWhitespaceSeparatorOffset();
        this.paintBackground(g, clip, this.getFoldingAreaOffset(), this.getFoldingAreaWidth());
        g.setColor(this.myEditor.getBackgroundColor());
        g.fillRect(lineX, clip.y, this.getFoldingAreaWidth(), clip.height);
        this.paintCaretRowBackground(g, lineX, this.getFoldingAnchorWidth());
    }

    private void paintFoldingLines(Graphics2D g, Rectangle clip) {
        if (!this.isFoldingOutlineShown()) {
            return;
        }
        UIUtil.drawVDottedLine((Graphics2D)g, (int)this.getWhitespaceSeparatorOffset(), (int)clip.y, (int)(clip.y + clip.height), null, (Color)this.getOutlineColor(false));
        int anchorX = this.getFoldingAreaOffset();
        int width = this.getFoldingAnchorWidth();
        if (this.myActiveFoldRegion != null && this.myActiveFoldRegion.isExpanded() && this.myActiveFoldRegion.isValid()) {
            int foldStart = this.myEditor.offsetToVisualLine(this.myActiveFoldRegion.getStartOffset());
            int foldEnd = this.myEditor.offsetToVisualLine(this.getEndOffset(this.myActiveFoldRegion));
            int startY = this.myEditor.visibleLineToY(foldStart + 1) - this.myEditor.getDescent();
            int endY = this.myEditor.visibleLineToY(foldEnd) + this.myEditor.getLineHeight() - this.myEditor.getDescent();
            if (startY <= clip.y + clip.height && endY + 1 + this.myEditor.getDescent() >= clip.y) {
                int lineX = anchorX + width / 2;
                g.setColor(this.getOutlineColor(true));
                UIUtil.drawLine((Graphics)g, (int)lineX, (int)startY, (int)lineX, (int)endY);
            }
        }
    }

    @Override
    public int getWhitespaceSeparatorOffset() {
        return this.getFoldingAreaOffset() + this.getFoldingAnchorWidth() / 2;
    }

    public void setActiveFoldRegion(FoldRegion activeFoldRegion) {
        if (this.myActiveFoldRegion != activeFoldRegion) {
            this.myActiveFoldRegion = activeFoldRegion;
            this.repaint();
        }
    }

    public int getHeadCenterY(FoldRegion foldRange) {
        int width = this.getFoldingAnchorWidth();
        int foldStart = this.myEditor.offsetToVisualLine(foldRange.getStartOffset());
        return this.myEditor.visibleLineToY(foldStart) + this.myEditor.getLineHeight() - this.myEditor.getDescent() - width / 2;
    }

    private void drawAnchor(int width, Rectangle clip, Graphics2D g, int anchorX, int visualLine, DisplayedFoldingAnchor.Type type, boolean active) {
        int height = width + 2;
        switch (type) {
            case COLLAPSED: {
                int y = this.myEditor.visibleLineToY(visualLine) + this.myEditor.getLineHeight() - this.myEditor.getDescent() - width;
                if (y > clip.y + clip.height || y + height < clip.y) break;
                this.drawSquareWithPlus(g, anchorX, y, width, active);
                break;
            }
            case EXPANDED_TOP: {
                int y = this.myEditor.visibleLineToY(visualLine) + this.myEditor.getLineHeight() - this.myEditor.getDescent() - width;
                if (y > clip.y + clip.height || y + height < clip.y) break;
                this.drawDirectedBox(g, anchorX, y, width, height, width - 2, active);
                break;
            }
            case EXPANDED_BOTTOM: {
                int y = this.myEditor.visibleLineToY(visualLine) + this.myEditor.getLineHeight() - this.myEditor.getDescent();
                if (y - height > clip.y + clip.height || y < clip.y) break;
                this.drawDirectedBox(g, anchorX, y, width, -height, -width + 2, active);
            }
        }
    }

    private int getEndOffset(FoldRegion foldRange) {
        LOG.assertTrue(foldRange.isValid(), (Object)foldRange);
        FoldingGroup group = foldRange.getGroup();
        return group == null ? foldRange.getEndOffset() : this.myEditor.getFoldingModel().getEndOffset(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawDirectedBox(Graphics2D g, int anchorX, int y, int width, int height, int baseHeight, boolean active) {
        Object antialiasing = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (SystemInfo.isMac && SystemInfo.JAVA_VERSION.startsWith("1.4.1") || UIUtil.isRetina()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        try {
            int[] xPoints = new int[]{anchorX, anchorX + width, anchorX + width, anchorX + width / 2, anchorX};
            int[] yPoints = new int[]{y, y, y + baseHeight, y + height, y + baseHeight};
            g.setColor(this.myEditor.getBackgroundColor());
            g.fillPolygon(xPoints, yPoints, 5);
            g.setColor(this.getOutlineColor(active));
            g.drawPolygon(xPoints, yPoints, 5);
            int minusHeight = y + baseHeight / 2 + (height - baseHeight) / 4;
            UIUtil.drawLine((Graphics)g, (int)(anchorX + 2), (int)minusHeight, (int)(anchorX + width - 2), (int)minusHeight);
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        }
    }

    private void drawSquareWithPlus(Graphics2D g, int anchorX, int y, int width, boolean active) {
        this.drawSquareWithMinus(g, anchorX, y, width, active);
        UIUtil.drawLine((Graphics)g, (int)(anchorX + width / 2), (int)(y + 2), (int)(anchorX + width / 2), (int)(y + width - 2));
    }

    private void drawSquareWithMinus(Graphics2D g, int anchorX, int y, int width, boolean active) {
        g.setColor(this.myEditor.getBackgroundColor());
        g.fillRect(anchorX, y, width, width);
        g.setColor(this.getOutlineColor(active));
        g.drawRect(anchorX, y, width, width);
        if (!active) {
            g.setColor(this.getOutlineColor(true));
        }
        UIUtil.drawLine((Graphics)g, (int)(anchorX + 2), (int)(y + width / 2), (int)(anchorX + width - 2), (int)(y + width / 2));
    }

    private int getFoldingAnchorWidth() {
        return Math.min(4, this.myEditor.getLineHeight() / 2 - 2) * 2;
    }

    public int getFoldingAreaOffset() {
        return this.getLineMarkerAreaOffset() + this.getLineMarkerAreaWidth();
    }

    public int getFoldingAreaWidth() {
        return this.isFoldingOutlineShown() ? this.getFoldingAnchorWidth() + 2 : 0;
    }

    @Override
    public boolean isLineMarkersShown() {
        return this.myEditor.getSettings().isLineMarkerAreaShown();
    }

    public boolean isLineNumbersShown() {
        return this.myEditor.getSettings().isLineNumbersShown();
    }

    @Override
    public boolean isAnnotationsShown() {
        return !this.myTextAnnotationGutters.isEmpty();
    }

    @Override
    public boolean isFoldingOutlineShown() {
        return this.myEditor.getSettings().isFoldingOutlineShown() && this.myEditor.getFoldingModel().isFoldingEnabled() && !this.myEditor.isInPresentationMode();
    }

    public int getLineNumberAreaWidth() {
        return this.isLineNumbersShown() ? this.myLineNumberAreaWidth : 0;
    }

    public int getLineMarkerAreaWidth() {
        return this.isLineMarkersShown() ? this.myLineMarkerAreaWidth : 0;
    }

    public void setLineNumberAreaWidth(@NotNull TIntFunction calculator) {
        int lineNumberAreaWidth;
        if (calculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculator", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "setLineNumberAreaWidth"));
        }
        int maxLineNumber = 0;
        for (int i = this.endLineNumber(); i >= 0; --i) {
            int number = this.myLineNumberConvertor.execute(i);
            if (number < 0) continue;
            maxLineNumber = number;
            break;
        }
        if (this.myLineNumberAreaWidth != (lineNumberAreaWidth = calculator.execute(maxLineNumber))) {
            this.myLineNumberAreaWidth = lineNumberAreaWidth;
            this.fireResized();
        }
    }

    @Nullable
    public EditorMouseEventArea getEditorMouseAreaByOffset(int offset) {
        int x = offset - EditorGutterComponentImpl.getLineNumberAreaOffset();
        if (x >= 0 && (x -= this.getLineNumberAreaWidth()) < 0) {
            return EditorMouseEventArea.LINE_NUMBERS_AREA;
        }
        if (x >= 0 && (x -= this.getAnnotationsAreaWidth()) < 0) {
            return EditorMouseEventArea.ANNOTATIONS_AREA;
        }
        if ((x -= this.myTextAnnotationExtraSize * 3 / 5) >= 0 && (x -= this.myTextAnnotationExtraSize * 2 / 5) < 0) {
            return EditorMouseEventArea.LINE_MARKERS_AREA;
        }
        if (x >= 0 && (x -= this.getLineMarkerAreaWidth()) < 0) {
            return EditorMouseEventArea.LINE_MARKERS_AREA;
        }
        if (x >= 0 && (x -= this.getFoldingAreaWidth()) < 0) {
            return EditorMouseEventArea.FOLDING_OUTLINE_AREA;
        }
        return null;
    }

    public static int getLineNumberAreaOffset() {
        return 0;
    }

    public int getAnnotationsAreaOffset() {
        return EditorGutterComponentImpl.getLineNumberAreaOffset() + this.getLineNumberAreaWidth();
    }

    public int getAnnotationsAreaWidth() {
        return this.myTextAnnotationGuttersSize;
    }

    public int getAnnotationsAreaWidthEx() {
        return this.myTextAnnotationGuttersSize + this.myTextAnnotationExtraSize;
    }

    @Override
    public int getLineMarkerAreaOffset() {
        return this.getAnnotationsAreaOffset() + this.getAnnotationsAreaWidthEx();
    }

    @Override
    public int getIconsAreaWidth() {
        return this.myIconsAreaWidth;
    }

    private boolean isMirrored() {
        return this.myEditor.getVerticalScrollbarOrientation() != 1;
    }

    @Override
    @Nullable
    public FoldRegion findFoldingAnchorAt(int x, int y) {
        if (!this.myEditor.getSettings().isFoldingOutlineShown()) {
            return null;
        }
        int anchorX = this.getFoldingAreaOffset();
        int anchorWidth = this.getFoldingAnchorWidth();
        int neighbourhoodStartOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, y - this.myEditor.getLineHeight())));
        int neighbourhoodEndOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, y + this.myEditor.getLineHeight())));
        Collection<DisplayedFoldingAnchor> displayedAnchors = this.myAnchorsDisplayStrategy.getAnchorsToDisplay(neighbourhoodStartOffset, neighbourhoodEndOffset, null);
        for (DisplayedFoldingAnchor anchor : displayedAnchors) {
            if (!this.rectangleByFoldOffset(anchor.visualLine, anchorWidth, anchorX).contains(x, y)) continue;
            return anchor.foldRegion;
        }
        return null;
    }

    private Rectangle rectangleByFoldOffset(int foldStart, int anchorWidth, int anchorX) {
        int anchorY = this.myEditor.visibleLineToY(foldStart) + this.myEditor.getLineHeight() - this.myEditor.getDescent() - anchorWidth;
        return new Rectangle(anchorX, anchorY, anchorWidth, anchorWidth);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TooltipController.getInstance().cancelTooltips();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        String toolTip = null;
        final GutterIconRenderer renderer = this.getGutterRenderer(e);
        TooltipController controller = TooltipController.getInstance();
        if (renderer != null) {
            toolTip = renderer.getTooltipText();
            if (renderer.isNavigateAction()) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                TextAnnotationGutterProvider provider = this.getProviderAtPoint(e.getPoint());
                if (provider != null) {
                    EditorGutterAction action;
                    int line = this.getLineNumAtPoint(e.getPoint());
                    toolTip = provider.getToolTip(line, (Editor)this.myEditor);
                    if (!Comparing.equal((String)toolTip, (String)this.myLastGutterToolTip)) {
                        controller.cancelTooltip(GUTTER_TOOLTIP_GROUP, e, true);
                        this.myLastGutterToolTip = toolTip;
                    }
                    if (this.myProviderToListener.containsKey(provider) && (action = this.myProviderToListener.get(provider)) != null) {
                        this.setCursor(action.getCursor(line));
                    }
                }
            }
        }
        if (toolTip != null && !toolTip.isEmpty()) {
            final Ref t = new Ref((Object)e.getPoint());
            int line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, e);
            List row = (List)this.myLineToGutterRenderers.get(line);
            Balloon.Position ballPosition = Balloon.Position.atRight;
            if (row != null) {
                final TreeMap xPos = new TreeMap();
                final int[] currentPos = new int[]{0};
                this.processIconsRow(line, row, new LineGutterIconRendererProcessor(){

                    @Override
                    public void process(int x, int y, GutterMark r) {
                        xPos.put(x, r);
                        if (renderer == r && r != null) {
                            currentPos[0] = x;
                            Icon icon = r.getIcon();
                            t.set((Object)new Point(x + icon.getIconWidth() / 2, y + icon.getIconHeight() / 2));
                        }
                    }
                });
                ArrayList xx = new ArrayList(xPos.keySet());
                int posIndex = xx.indexOf(currentPos[0]);
                if (xPos.size() > 1 && posIndex == 0) {
                    ballPosition = Balloon.Position.below;
                }
            }
            RelativePoint showPoint = new RelativePoint((Component)this, (Point)t.get());
            controller.showTooltipByMouseMove(this.myEditor, showPoint, ((EditorMarkupModel)((Object)this.myEditor.getMarkupModel())).getErrorStripTooltipRendererProvider().calcTooltipRenderer(toolTip), false, GUTTER_TOOLTIP_GROUP, new HintHint(this, (Point)t.get()).setAwtTooltip(true).setPreferredPosition(ballPosition));
        } else {
            controller.cancelTooltip(GUTTER_TOOLTIP_GROUP, e, false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
        }
    }

    private void fireEventToTextAnnotationListeners(MouseEvent e) {
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            int line;
            Point clickPoint = e.getPoint();
            TextAnnotationGutterProvider provider = this.getProviderAtPoint(clickPoint);
            if (provider == null) {
                return;
            }
            if (this.myProviderToListener.containsKey(provider) && (line = this.getLineNumAtPoint(clickPoint)) >= 0 && line < this.myEditor.getDocument().getLineCount() && UIUtil.isActionClick((MouseEvent)e, (int)502)) {
                this.myProviderToListener.get(provider).doAction(line);
            }
        }
    }

    private int getLineNumAtPoint(Point clickPoint) {
        return EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, clickPoint);
    }

    @Nullable
    private TextAnnotationGutterProvider getProviderAtPoint(Point clickPoint) {
        int current = this.getAnnotationsAreaOffset();
        if (clickPoint.x < current) {
            return null;
        }
        for (int i = 0; i < this.myTextAnnotationGutterSizes.size(); ++i) {
            if (clickPoint.x > (current += this.myTextAnnotationGutterSizes.get(i))) continue;
            return this.myTextAnnotationGutters.get(i);
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
            this.myPopupInvokedOnPressed = true;
        } else if (UIUtil.isCloseClick((MouseEvent)e)) {
            this.processClose(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
            return;
        }
        if (this.myPopupInvokedOnPressed) {
            this.myPopupInvokedOnPressed = false;
            return;
        }
        GutterIconRenderer renderer = this.getGutterRenderer(e);
        AnAction clickAction = null;
        if (renderer != null && e.getButton() < 4) {
            AnAction anAction = clickAction = (8 & e.getModifiers()) > 0 ? renderer.getMiddleButtonClickAction() : renderer.getClickAction();
        }
        if (clickAction != null) {
            clickAction.actionPerformed(new AnActionEvent((InputEvent)e, this.myEditor.getDataContext(), "ICON_NAVIGATION", clickAction.getTemplatePresentation(), ActionManager.getInstance(), e.getModifiers()));
            e.consume();
            this.repaint();
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                lineRenderer.doAction((Editor)this.myEditor, e);
            } else {
                this.fireEventToTextAnnotationListeners(e);
            }
        }
    }

    @Nullable
    private ActiveGutterRenderer getActiveRendererByMouseEvent(final MouseEvent e) {
        if (this.findFoldingAnchorAt(e.getX(), e.getY()) != null) {
            return null;
        }
        if (e.isConsumed() || e.getX() > this.getWhitespaceSeparatorOffset()) {
            return null;
        }
        final ActiveGutterRenderer[] gutterRenderer = new ActiveGutterRenderer[]{null};
        Rectangle clip = this.myEditor.getScrollingModel().getVisibleArea();
        int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
        int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
        this.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, new RangeHighlighterProcessor(){

            @Override
            public void process(@NotNull RangeHighlighter highlighter) {
                LineMarkerRenderer renderer;
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$11", "process"));
                }
                if (gutterRenderer[0] != null) {
                    return;
                }
                Rectangle rectangle = EditorGutterComponentImpl.this.getLineRendererRectangle(highlighter);
                if (rectangle == null) {
                    return;
                }
                int startY = rectangle.y;
                int endY = startY + rectangle.height;
                if (startY == endY) {
                    endY += EditorGutterComponentImpl.this.myEditor.getLineHeight();
                }
                if (startY < e.getY() && e.getY() <= endY && (renderer = highlighter.getLineMarkerRenderer()) instanceof ActiveGutterRenderer && ((ActiveGutterRenderer)renderer).canDoAction(e)) {
                    gutterRenderer[0] = (ActiveGutterRenderer)renderer;
                }
            }
        });
        return gutterRenderer[0];
    }

    public void closeAllAnnotations() {
        for (TextAnnotationGutterProvider provider : this.myTextAnnotationGutters) {
            provider.gutterClosed();
        }
        this.revalidateSizes();
    }

    private void revalidateSizes() {
        this.myTextAnnotationGutters = new ArrayList();
        this.myTextAnnotationGutterSizes = new TIntArrayList();
        this.updateSize();
    }

    @Override
    @Nullable
    public Point getPoint(final GutterIconRenderer renderer) {
        final Ref result = Ref.create();
        for (int line : this.myLineToGutterRenderers.keys()) {
            this.processIconsRow(line, (List)this.myLineToGutterRenderers.get(line), new LineGutterIconRendererProcessor(){

                @Override
                public void process(int x, int y, GutterMark r) {
                    if (result.isNull() && r.equals(renderer)) {
                        result.set((Object)new Point(x, y));
                    }
                }
            });
            if (result.isNull()) continue;
            return (Point)result.get();
        }
        return null;
    }

    @Override
    public void setLineNumberConvertor(@NotNull TIntFunction lineNumberConvertor) {
        if (lineNumberConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineNumberConvertor", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl", "setLineNumberConvertor"));
        }
        this.myLineNumberConvertor = lineNumberConvertor;
    }

    @Override
    public void setShowDefaultGutterPopup(boolean show) {
        this.myShowDefaultGutterPopup = show;
    }

    private void invokePopup(MouseEvent e) {
        ActionManager actionManager = ActionManager.getInstance();
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            DefaultActionGroup actionGroup = new DefaultActionGroup(EditorBundle.message((String)"editor.annotations.action.group.name", (Object[])new Object[0]), true);
            actionGroup.add((AnAction)new CloseAnnotationsAction());
            ArrayList<AnAction> addActions = new ArrayList<AnAction>();
            Point p = e.getPoint();
            int line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, p);
            for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
                List list = gutterProvider.getPopupActions(line, (Editor)this.myEditor);
                if (list == null) continue;
                for (AnAction action : list) {
                    if (addActions.contains(action)) continue;
                    addActions.add(action);
                }
            }
            for (AnAction addAction : addActions) {
                actionGroup.add(addAction);
            }
            JPopupMenu menu = actionManager.createActionPopupMenu("", (ActionGroup)actionGroup).getComponent();
            menu.show(this, e.getX(), e.getY());
        } else {
            GutterIconRenderer renderer = this.getGutterRenderer(e);
            if (renderer != null) {
                ActionGroup actionGroup = renderer.getPopupMenuActions();
                if (actionGroup != null) {
                    ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", actionGroup);
                    popupMenu.getComponent().show(this, e.getX(), e.getY());
                    e.consume();
                } else {
                    AnAction rightButtonAction = renderer.getRightButtonClickAction();
                    if (rightButtonAction != null) {
                        rightButtonAction.actionPerformed(new AnActionEvent((InputEvent)e, this.myEditor.getDataContext(), "ICON_NAVIGATION_SECONDARY_BUTTON", rightButtonAction.getTemplatePresentation(), ActionManager.getInstance(), e.getModifiers()));
                        e.consume();
                    }
                }
            } else {
                if (this.myShowDefaultGutterPopup) {
                    ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorGutterPopupMenu");
                    ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", group);
                    popupMenu.getComponent().show(this, e.getX(), e.getY());
                }
                e.consume();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        TooltipController.getInstance().cancelTooltip(GUTTER_TOOLTIP_GROUP, e, false);
    }

    private int convertPointToLineNumber(Point p) {
        int line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, p);
        if (line >= this.myEditor.getDocument().getLineCount()) {
            return -1;
        }
        int startOffset = this.myEditor.getDocument().getLineStartOffset(line);
        FoldRegion region = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (region != null && (line = this.myEditor.getDocument().getLineNumber(region.getEndOffset())) >= this.myEditor.getDocument().getLineCount()) {
            return -1;
        }
        return line;
    }

    @Nullable
    private GutterMark getGutterRenderer(final Point p) {
        int line = this.convertPointToLineNumber(p);
        if (line == -1) {
            return null;
        }
        List renderers = (List)this.myLineToGutterRenderers.get(line);
        if (renderers == null) {
            return null;
        }
        final GutterMark[] result = new GutterMark[]{null};
        this.processIconsRow(line, renderers, new LineGutterIconRendererProcessor(){

            @Override
            public void process(int x, int y, GutterMark renderer) {
                int ex = EditorGutterComponentImpl.this.convertX((int)p.getX());
                Icon icon = renderer.getIcon();
                if (x <= ex && ex <= x + icon.getIconWidth()) {
                    result[0] = renderer;
                }
            }
        });
        return result[0];
    }

    @Nullable
    private GutterIconRenderer getGutterRenderer(MouseEvent e) {
        return (GutterIconRenderer)this.getGutterRenderer(e.getPoint());
    }

    public int convertX(int x) {
        if (!this.isMirrored()) {
            return x;
        }
        return this.getWidth() - x;
    }

    public void dispose() {
        for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
            gutterProvider.gutterClosed();
        }
        this.myProviderToListener.clear();
    }

    private class CloseAnnotationsAction
    extends DumbAwareAction {
        public CloseAnnotationsAction() {
            super(EditorBundle.message((String)"close.editor.annotations.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            EditorGutterComponentImpl.this.closeAllAnnotations();
        }
    }

    private static interface LineGutterIconRendererProcessor {
        public void process(int var1, int var2, GutterMark var3);
    }

    private static interface RangeHighlighterProcessor {
        public void process(@NotNull RangeHighlighter var1);
    }
}

