/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.AdditionalTextAttributesEP;
import com.intellij.openapi.editor.colors.impl.BundledColorSchemeEP;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsSchemeImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsManagerImpl
extends EditorColorsManager
implements NamedJDOMExternalizable,
ExportableComponent,
NamedComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl");
    private final EventDispatcher<EditorColorsListener> myListeners = EventDispatcher.create(EditorColorsListener.class);
    @NonNls
    private static final String NODE_NAME = "global_color_scheme";
    @NonNls
    private static final String SCHEME_NODE_NAME = "scheme";
    private String myGlobalSchemeName;
    public boolean USE_ONLY_MONOSPACED_FONTS = true;
    private final DefaultColorSchemesManager myDefaultColorSchemesManager;
    private final SchemesManager<EditorColorsScheme, EditorColorsSchemeImpl> mySchemesManager;
    @NonNls
    private static final String NAME_ATTR = "name";
    private static final String FILE_SPEC = "$ROOT_CONFIG$/colors";
    private static final String FILE_EXT = ".icls";

    public EditorColorsManagerImpl(DefaultColorSchemesManager defaultColorSchemesManager, SchemesManagerFactory schemesManagerFactory) {
        this.myDefaultColorSchemesManager = defaultColorSchemesManager;
        this.mySchemesManager = schemesManagerFactory.createSchemesManager(FILE_SPEC, (SchemeProcessor)new MySchemeProcessor(), RoamingType.PER_USER);
        this.addDefaultSchemes();
        if (!EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            this.loadSchemesFromBeans();
        }
        this.loadAllSchemes();
        this.loadAdditionalTextAttributes();
        String wizardEditorScheme = WelcomeWizardUtil.getWizardEditorScheme();
        EditorColorsScheme scheme = null;
        if (wizardEditorScheme != null) {
            scheme = this.getScheme(wizardEditorScheme);
            LOG.assertTrue(scheme != null, (Object)("Wizard scheme " + wizardEditorScheme + " not found"));
        }
        if (scheme == null) {
            scheme = this.myDefaultColorSchemesManager.getAllSchemes()[0];
        }
        this.setGlobalSchemeInner(scheme);
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public TextAttributes getDefaultAttributes(TextAttributesKey key) {
        boolean dark = UIUtil.isUnderDarcula() && this.getScheme("Darcula") != null;
        EditorColorsScheme defaultColorScheme = this.getScheme(dark ? "Darcula" : "Default");
        return defaultColorScheme.getAttributes(key);
    }

    private void loadSchemesFromBeans() {
        for (BundledColorSchemeEP schemeEP : (BundledColorSchemeEP[])Extensions.getExtensions(BundledColorSchemeEP.EP_NAME)) {
            String fileName = schemeEP.path + ".xml";
            InputStream stream = schemeEP.getLoaderForClass().getResourceAsStream(fileName);
            try {
                EditorColorsSchemeImpl scheme = EditorColorsManagerImpl.loadSchemeFromStream(fileName, stream);
                if (scheme == null) continue;
                this.mySchemesManager.addNewScheme((Scheme)scheme, false);
            }
            catch (Exception e) {
                LOG.error("Cannot read scheme from " + fileName + ": " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void loadAdditionalTextAttributes() {
        for (AdditionalTextAttributesEP attributesEP : (AdditionalTextAttributesEP[])AdditionalTextAttributesEP.EP_NAME.getExtensions()) {
            EditorColorsScheme editorColorsScheme = (EditorColorsScheme)this.mySchemesManager.findSchemeByName(attributesEP.scheme);
            if (editorColorsScheme == null) {
                if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) continue;
                LOG.warn("Cannot find scheme: " + attributesEP.scheme + " from plugin: " + attributesEP.getPluginDescriptor().getPluginId());
                continue;
            }
            try {
                InputStream inputStream = attributesEP.getLoaderForClass().getResourceAsStream(attributesEP.file);
                Document document = JDOMUtil.loadDocument((InputStream)inputStream);
                ((AbstractColorsScheme)editorColorsScheme).readAttributes(document.getRootElement());
            }
            catch (Exception e1) {
                LOG.error((Throwable)e1);
            }
        }
    }

    private static EditorColorsSchemeImpl loadSchemeFromStream(String schemePath, InputStream inputStream) throws IOException, JDOMException, InvalidDataException {
        Document document;
        if (inputStream == null) {
            LOG.error("Cannot read scheme from " + schemePath);
            return null;
        }
        try {
            document = JDOMUtil.loadDocument((InputStream)inputStream);
        }
        catch (JDOMException e) {
            LOG.info("Error reading scheme from  " + schemePath + ": " + e.getLocalizedMessage());
            throw e;
        }
        return EditorColorsManagerImpl.loadSchemeFromDocument(document, false);
    }

    @NotNull
    private static EditorColorsSchemeImpl loadSchemeFromDocument(Document document, boolean isEditable) throws InvalidDataException {
        Element root = document.getRootElement();
        if (root == null || !SCHEME_NODE_NAME.equals(root.getName())) {
            throw new InvalidDataException();
        }
        EditorColorsSchemeImpl scheme = isEditable ? new EditorColorsSchemeImpl(null, DefaultColorSchemesManager.getInstance()) : new ReadOnlyColorsSchemeImpl(null, DefaultColorSchemesManager.getInstance());
        scheme.readExternal(root);
        EditorColorsSchemeImpl editorColorsSchemeImpl = scheme;
        if (editorColorsSchemeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "loadSchemeFromDocument"));
        }
        return editorColorsSchemeImpl;
    }

    public void addColorsScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SCHEME_NODE_NAME, "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "addColorsScheme"));
        }
        if (!this.isDefaultScheme(scheme) && scheme.getName().trim().length() > 0) {
            this.mySchemesManager.addNewScheme((Scheme)scheme, true);
        }
    }

    public void removeAllSchemes() {
        this.mySchemesManager.clearAllSchemes();
        this.addDefaultSchemes();
    }

    private void addDefaultSchemes() {
        DefaultColorsScheme[] allDefaultSchemes;
        for (DefaultColorsScheme defaultScheme : allDefaultSchemes = this.myDefaultColorSchemesManager.getAllSchemes()) {
            this.mySchemesManager.addNewScheme((Scheme)defaultScheme, true);
        }
    }

    @NotNull
    public EditorColorsScheme[] getAllSchemes() {
        ArrayList schemes = new ArrayList(this.mySchemesManager.getAllSchemes());
        Collections.sort(schemes, new Comparator<EditorColorsScheme>(){

            @Override
            public int compare(EditorColorsScheme s1, EditorColorsScheme s2) {
                if (EditorColorsManagerImpl.this.isDefaultScheme(s1) && !EditorColorsManagerImpl.this.isDefaultScheme(s2)) {
                    return -1;
                }
                if (!EditorColorsManagerImpl.this.isDefaultScheme(s1) && EditorColorsManagerImpl.this.isDefaultScheme(s2)) {
                    return 1;
                }
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        EditorColorsScheme[] editorColorsSchemeArray = schemes.toArray(new EditorColorsScheme[schemes.size()]);
        if (editorColorsSchemeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getAllSchemes"));
        }
        return editorColorsSchemeArray;
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme) {
        if (this.setGlobalSchemeInner(scheme)) {
            this.fireChanges(scheme);
            LafManager.getInstance().updateUI();
            EditorFactory.getInstance().refreshAllEditors();
        }
    }

    private boolean setGlobalSchemeInner(@Nullable EditorColorsScheme scheme) {
        String newValue = scheme == null ? EditorColorsManagerImpl.getDefaultScheme().getName() : scheme.getName();
        EditorColorsScheme oldValue = (EditorColorsScheme)this.mySchemesManager.getCurrentScheme();
        this.mySchemesManager.setCurrentSchemeName(newValue);
        return oldValue != null && !Comparing.equal((String)newValue, (String)oldValue.getName());
    }

    @NotNull
    private static DefaultColorsScheme getDefaultScheme() {
        DefaultColorsScheme defaultColorsScheme = DefaultColorSchemesManager.getInstance().getAllSchemes()[0];
        if (defaultColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getDefaultScheme"));
        }
        return defaultColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getGlobalScheme() {
        EditorColorsScheme scheme = (EditorColorsScheme)this.mySchemesManager.getCurrentScheme();
        if (scheme == null) {
            DefaultColorsScheme defaultColorsScheme = EditorColorsManagerImpl.getDefaultScheme();
            if (defaultColorsScheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getGlobalScheme"));
            }
            return defaultColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = scheme;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getGlobalScheme"));
        }
        return editorColorsScheme;
    }

    public EditorColorsScheme getScheme(String schemeName) {
        return (EditorColorsScheme)this.mySchemesManager.findSchemeByName(schemeName);
    }

    private void fireChanges(EditorColorsScheme scheme) {
        ((EditorColorsListener)this.myListeners.getMulticaster()).globalSchemeChange(scheme);
    }

    private void loadAllSchemes() {
        this.mySchemesManager.loadSchemes();
    }

    private static File getColorsDir(boolean create) {
        String directoryPath = PathManager.getConfigPath() + File.separator + "colors";
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            if (!create) {
                return null;
            }
            if (!directory.mkdir()) {
                LOG.error("Cannot create directory: " + directory.getAbsolutePath());
                return null;
            }
        }
        return directory;
    }

    public void addEditorColorsListener(@NotNull EditorColorsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "addEditorColorsListener"));
        }
        this.myListeners.addListener((EventListener)listener);
    }

    public void addEditorColorsListener(@NotNull EditorColorsListener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "addEditorColorsListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "addEditorColorsListener"));
        }
        this.myListeners.addListener((EventListener)listener, disposable);
    }

    public void removeEditorColorsListener(@NotNull EditorColorsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "removeEditorColorsListener"));
        }
        this.myListeners.removeListener((EventListener)listener);
    }

    public void setUseOnlyMonospacedFonts(boolean b) {
        this.USE_ONLY_MONOSPACED_FONTS = b;
    }

    public boolean isUseOnlyMonospacedFonts() {
        return this.USE_ONLY_MONOSPACED_FONTS;
    }

    public String getExternalFileName() {
        return "colors.scheme";
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{EditorColorsManagerImpl.getColorsDir(true), PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = OptionsBundle.message((String)"options.color.schemes.presentable.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getPresentableName"));
        }
        return string;
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        String name;
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)parentNode);
        Element element = parentNode.getChild(NODE_NAME);
        if (element != null && StringUtil.isNotEmpty((String)(name = element.getAttributeValue(NAME_ATTR)))) {
            this.myGlobalSchemeName = name;
        }
        DefaultColorsScheme globalScheme = this.myGlobalSchemeName != null ? (EditorColorsScheme)this.mySchemesManager.findSchemeByName(this.myGlobalSchemeName) : this.myDefaultColorSchemesManager.getAllSchemes()[0];
        this.setGlobalSchemeInner(globalScheme);
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)parentNode);
        if (this.mySchemesManager.getCurrentScheme() != null) {
            Element element = new Element(NODE_NAME);
            element.setAttribute(NAME_ATTR, ((EditorColorsScheme)this.mySchemesManager.getCurrentScheme()).getName());
            parentNode.addContent(element);
        }
    }

    public boolean isDefaultScheme(EditorColorsScheme scheme) {
        return scheme instanceof DefaultColorsScheme;
    }

    public SchemesManager<EditorColorsScheme, EditorColorsSchemeImpl> getSchemesManager() {
        return this.mySchemesManager;
    }

    @NotNull
    public String getComponentName() {
        if ("EditorColorsManagerImpl" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getComponentName"));
        }
        return "EditorColorsManagerImpl";
    }

    private final class MySchemeProcessor
    extends BaseSchemeProcessor<EditorColorsSchemeImpl>
    implements SchemeExtensionProvider {
        private MySchemeProcessor() {
        }

        public EditorColorsSchemeImpl readScheme(@NotNull Document document) throws InvalidDataException {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$MySchemeProcessor", "readScheme"));
            }
            return EditorColorsManagerImpl.loadSchemeFromDocument(document, true);
        }

        public Element writeScheme(@NotNull EditorColorsSchemeImpl scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", EditorColorsManagerImpl.SCHEME_NODE_NAME, "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$MySchemeProcessor", "writeScheme"));
            }
            Element root = new Element(EditorColorsManagerImpl.SCHEME_NODE_NAME);
            try {
                scheme.writeExternal(root);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
                return null;
            }
            return root;
        }

        public boolean shouldBeSaved(@NotNull EditorColorsSchemeImpl scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", EditorColorsManagerImpl.SCHEME_NODE_NAME, "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$MySchemeProcessor", "shouldBeSaved"));
            }
            return !(scheme instanceof ReadOnlyColorsScheme);
        }

        public void onCurrentSchemeChanged(Scheme newCurrentScheme) {
            EditorColorsManagerImpl.this.fireChanges((EditorColorsScheme)EditorColorsManagerImpl.this.mySchemesManager.getCurrentScheme());
        }

        @NotNull
        public String getSchemeExtension() {
            if (EditorColorsManagerImpl.FILE_EXT == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$MySchemeProcessor", "getSchemeExtension"));
            }
            return EditorColorsManagerImpl.FILE_EXT;
        }

        public boolean isUpgradeNeeded() {
            return true;
        }
    }
}

