/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TextEndWithSelectionAction
extends TextComponentEditorAction {
    public TextEndWithSelectionAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            int endOffset = editor.getDocument().getTextLength();
            List carets = editor.getCaretModel().getAllCarets();
            if (editor.isColumnMode() && editor.getCaretModel().supportsMultipleCarets()) {
                if (caret == null) {
                    caret = carets.get(0) == editor.getCaretModel().getPrimaryCaret() ? (Caret)carets.get(carets.size() - 1) : (Caret)carets.get(0);
                }
                LogicalPosition leadSelectionPosition = editor.visualToLogicalPosition(caret.getLeadSelectionPosition());
                LogicalPosition targetPosition = editor.offsetToLogicalPosition(endOffset);
                editor.getSelectionModel().setBlockSelection(leadSelectionPosition, targetPosition);
            } else {
                if (caret == null) {
                    caret = (Caret)carets.get(0);
                }
                int selectionStart = caret.getLeadSelectionOffset();
                caret.moveToOffset(endOffset);
                caret.setSelection(selectionStart, endOffset);
            }
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollToCaret(ScrollType.CENTER);
            scrollingModel.enableAnimation();
        }
    }
}

