/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;

public class SwapSelectionBoundariesAction
extends EditorAction {
    public SwapSelectionBoundariesAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        public Handler() {
            super(true);
        }

        public void execute(Editor editor, DataContext dataContext) {
            if (!(editor instanceof EditorEx)) {
                return;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                return;
            }
            EditorEx editorEx = (EditorEx)editor;
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            CaretModel caretModel = editor.getCaretModel();
            boolean moveToEnd = caretModel.getOffset() == start;
            editorEx.setStickySelection(false);
            editorEx.setStickySelection(true);
            if (moveToEnd) {
                caretModel.moveToOffset(end);
            } else {
                caretModel.moveToOffset(start);
            }
        }
    }
}

