/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class SelectWordAtCaretAction
extends TextComponentEditorAction
implements DumbAware {
    public SelectWordAtCaretAction() {
        super(new DefaultHandler());
        this.setInjectedContext(true);
    }

    public static class Handler
    extends EditorActionHandler {
        private final EditorActionHandler myDefaultHandler;

        public Handler(EditorActionHandler defaultHandler) {
            super(true);
            this.myDefaultHandler = defaultHandler;
        }

        public void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            IndentGuideDescriptor guide = editor.getIndentsModel().getCaretIndentGuide();
            SelectionModel selectionModel = editor.getSelectionModel();
            if (guide != null && !selectionModel.hasSelection() && !selectionModel.hasBlockSelection() && Handler.isWhitespaceAtCaret(editor)) {
                Handler.selectWithGuide(editor, guide);
            } else {
                this.myDefaultHandler.execute(editor, caret, dataContext);
            }
        }

        private static boolean isWhitespaceAtCaret(Editor editor) {
            Document doc = editor.getDocument();
            int offset = editor.getCaretModel().getOffset();
            if (offset >= doc.getTextLength()) {
                return false;
            }
            char c = doc.getCharsSequence().charAt(offset);
            return c == ' ' || c == '\t' || c == '\n';
        }

        private static void selectWithGuide(Editor editor, IndentGuideDescriptor guide) {
            Document doc = editor.getDocument();
            int startOffset = editor.logicalPositionToOffset(new LogicalPosition(guide.startLine, 0));
            int endOffset = guide.endLine >= doc.getLineCount() ? doc.getTextLength() : doc.getLineStartOffset(guide.endLine);
            VirtualFile file = ((EditorEx)editor).getVirtualFile();
            if (file != null) {
                CharSequence chars = doc.getCharsSequence();
                int nonWhitespaceOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)endOffset, (String)" \t\n");
                HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(nonWhitespaceOffset);
                if (BraceMatchingUtil.isRBraceToken(iterator, chars, file.getFileType()) && ((EditorEx)editor).calcColumnNumber(iterator.getStart(), doc.getLineNumber(iterator.getStart())) == guide.indentLevel) {
                    endOffset = iterator.getEnd();
                    if ((endOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)endOffset, (String)" \t")) < chars.length() && chars.charAt(endOffset) == '\n') {
                        ++endOffset;
                    }
                }
            }
            editor.getSelectionModel().setSelection(startOffset, endOffset);
        }
    }

    private static class DefaultHandler
    extends EditorActionHandler {
        private DefaultHandler() {
            super(true);
        }

        public void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            int lineNumber = editor.getCaretModel().getLogicalPosition().line;
            int caretOffset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            if (lineNumber >= document.getLineCount()) {
                return;
            }
            CharSequence text = document.getCharsSequence();
            boolean camel = editor.getSettings().isCamelWords();
            ArrayList<TextRange> ranges = new ArrayList<TextRange>();
            int textLength = document.getTextLength();
            if (caretOffset == textLength) {
                --caretOffset;
            }
            if (caretOffset < 0) {
                return;
            }
            SelectWordUtil.addWordSelection(camel, text, caretOffset, ranges);
            if (ranges.isEmpty()) {
                return;
            }
            int startWordOffset = Math.max(0, ((TextRange)ranges.get(0)).getStartOffset());
            int endWordOffset = Math.min(((TextRange)ranges.get(0)).getEndOffset(), document.getTextLength());
            SelectionModel selectionModel = editor.getSelectionModel();
            if (camel && ranges.size() == 2 && selectionModel.getSelectionStart() == startWordOffset && selectionModel.getSelectionEnd() == endWordOffset) {
                startWordOffset = Math.max(0, ((TextRange)ranges.get(1)).getStartOffset());
                endWordOffset = Math.min(((TextRange)ranges.get(1)).getEndOffset(), document.getTextLength());
            }
            if (startWordOffset >= selectionModel.getSelectionStart() && selectionModel.getSelectionEnd() >= endWordOffset && ranges.size() == 1) {
                startWordOffset = 0;
                endWordOffset = document.getTextLength();
            }
            selectionModel.setSelection(startWordOffset, endWordOffset);
        }
    }
}

