/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class HungryBackspaceAction
extends TextComponentEditorAction {
    public HungryBackspaceAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public void executeWriteAction(@NotNull Editor editor, DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/HungryBackspaceAction$Handler", "executeWriteAction"));
            }
            Document document = editor.getDocument();
            int prevSymbolOffset = editor.getCaretModel().getOffset() - 1;
            if (prevSymbolOffset < 0) {
                return;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            CharSequence text = document.getCharsSequence();
            char c = text.charAt(prevSymbolOffset);
            boolean doHungryCheck = !selectionModel.hasSelection() && !selectionModel.hasBlockSelection() && StringUtil.isWhiteSpace((char)c);
            EditorActionHandler handler = EditorActionManager.getInstance().getActionHandler("EditorBackSpace");
            handler.execute(editor, dataContext);
            if (!doHungryCheck) {
                return;
            }
            int endOffset = prevSymbolOffset;
            if (endOffset > document.getTextLength()) {
                return;
            }
            int startOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)(endOffset - 1), (String)"\t \n");
            startOffset = startOffset < 0 ? 0 : ++startOffset;
            if (startOffset >= endOffset) {
                return;
            }
            document.deleteString(startOffset, endOffset);
        }
    }
}

