/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToggleUseSoftWrapsAction
extends ToggleAction {
    private final SoftWrapAppliancePlaces myAppliancePlace;
    private final boolean myGlobal;

    public AbstractToggleUseSoftWrapsAction(@NotNull SoftWrapAppliancePlaces appliancePlace, boolean global) {
        if (appliancePlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appliancePlace", "com/intellij/openapi/editor/actions/AbstractToggleUseSoftWrapsAction", "<init>"));
        }
        this.myAppliancePlace = appliancePlace;
        this.myGlobal = global;
    }

    public boolean isSelected(AnActionEvent e) {
        Editor editor = this.getEditor(e);
        return editor != null && editor.getSettings().isUseSoftWraps();
    }

    public void setSelected(AnActionEvent e, boolean state2) {
        Editor editor = this.getEditor(e);
        if (editor == null) {
            return;
        }
        if (this.myGlobal) {
            EditorSettingsExternalizable.getInstance().setUseSoftWraps(state2, this.myAppliancePlace);
        } else {
            editor.getSettings().setUseSoftWraps(state2);
        }
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).reinitSettings();
        }
    }

    @Nullable
    protected Editor getEditor(AnActionEvent e) {
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }
}

