/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import org.jetbrains.annotations.NonNls;

public abstract class DiffPreviewProvider {
    public static final ExtensionPointName<DiffPreviewProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.diffPreviewProvider");
    @NonNls
    private static final String LEFT_TEXT = "class MyClass {\n  int value;\n\n  void leftOnly() {}\n\n  void foo() {\n   // Left changes\n  }\n}";
    @NonNls
    private static final String CENTER_TEXT = "class MyClass {\n  int value;\n\n  void foo() {\n  }\n\n  void removedFromLeft() {}\n}";
    @NonNls
    private static final String RIGHT_TEXT = "class MyClass {\n  long value;\n\n  void foo() {\n   // Right changes\n  }\n\n  void removedFromLeft() {}\n}";

    public abstract DiffContent[] createContents();

    public static DiffContent[] getContents() {
        DiffPreviewProvider[] providers = (DiffPreviewProvider[])Extensions.getExtensions(EP_NAME);
        if (providers.length != 0) {
            return providers[0].createContents();
        }
        return new DiffContent[]{DiffPreviewProvider.createContent(LEFT_TEXT), DiffPreviewProvider.createContent(CENTER_TEXT), DiffPreviewProvider.createContent(RIGHT_TEXT)};
    }

    private static SimpleContent createContent(String text) {
        return new SimpleContent(text, (FileType)StdFileTypes.JAVA);
    }
}

