/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class SelectFilesToAddTextsToPatchPanel
implements RefreshablePanel {
    private final Set<String> myBigFiles;
    private final ChangesBrowser myBrowser;
    private JLabel myWarningText;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.patch.SelectFilesToAddTextsToPatchPanel");
    private final int myTotalSize;
    private JPanel myPanel;
    private final Runnable myInclusionListener;
    private JLabel myBaseRevisionTextShouldLabel;

    public SelectFilesToAddTextsToPatchPanel(Project project, List<Change> changes, Collection<Change> selectedChanges, final @NotNull Runnable inclusionListener) {
        if (inclusionListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inclusionListener", "com/intellij/openapi/diff/impl/patch/SelectFilesToAddTextsToPatchPanel", "<init>"));
        }
        this.myTotalSize = changes.size();
        this.myBigFiles = new HashSet<String>();
        Set<Change> exclude = SelectFilesToAddTextsToPatchPanel.getBig(changes);
        for (Change change : exclude) {
            this.myBigFiles.add(ChangesUtil.getFilePath((Change)change).getPath());
        }
        this.myWarningText = new JLabel("There are big files selected, which increases patch size significantly");
        this.myWarningText.setIcon(UIUtil.getBalloonWarningIcon());
        this.myInclusionListener = new Runnable(){

            @Override
            public void run() {
                Collection<Change> includedChanges = SelectFilesToAddTextsToPatchPanel.this.myBrowser.getViewer().getIncludedChanges();
                inclusionListener.run();
                for (Change change : includedChanges) {
                    if (!SelectFilesToAddTextsToPatchPanel.this.myBigFiles.contains(ChangesUtil.getFilePath((Change)change).getPath())) continue;
                    SelectFilesToAddTextsToPatchPanel.this.myWarningText.setVisible(true);
                    return;
                }
                SelectFilesToAddTextsToPatchPanel.this.myWarningText.setVisible(false);
            }
        };
        this.myBrowser = new ChangesBrowser(project, null, changes, null, true, false, this.myInclusionListener, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.myBrowser.getViewer().setChangeDecorator(new ChangeNodeDecorator(){

            @Override
            public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
                String path = ChangesUtil.getFilePath((Change)change).getPath();
                if (SelectFilesToAddTextsToPatchPanel.this.myBigFiles.contains(path)) {
                    component.append(" ");
                    component.append("File size is bigger than 500K", SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }

            @Override
            public List<Pair<String, ChangeNodeDecorator.Stress>> stressPartsOfFileName(Change change, String parentPath) {
                return null;
            }

            @Override
            public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
            }
        });
        this.myBrowser.getViewer().setChangesToDisplay(changes);
        if (selectedChanges == null) {
            this.myBrowser.getViewer().excludeChanges(exclude);
        } else {
            this.myBrowser.getViewer().excludeChanges(changes);
            this.myBrowser.getViewer().includeChanges(selectedChanges);
        }
        this.myWarningText.setVisible(false);
        this.myInclusionListener.run();
    }

    public void setEnabled(boolean selected) {
        this.myBrowser.getViewer().enableSelection(selected);
    }

    public static Set<Change> getBig(List<Change> changes) {
        HashSet<Change> exclude = new HashSet<Change>();
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision == null) continue;
            try {
                String content = beforeRevision.getContent();
                if (content == null) {
                    FilePath file = beforeRevision.getFile();
                    LOG.info("null content for " + (file == null ? null : file.getPath()) + ", is dir: " + (file == null ? null : Boolean.valueOf(file.isDirectory())));
                    continue;
                }
                if ((long)content.length() <= 500000L) continue;
                exclude.add(change);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
        return exclude;
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean refreshDataSynch() {
        return false;
    }

    public boolean isStillValid(Object o) {
        return false;
    }

    @Override
    public JPanel getPanel() {
        if (this.myPanel == null) {
            this.createCenterPanel();
        }
        return this.myPanel;
    }

    @Override
    public void away() {
    }

    public void dispose() {
    }

    public JComponent createCenterPanel() {
        this.myPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0);
        String sb = "<html>Base revision texts are worth including into the patch, if it is about to be used in projects under DVCS.<br/>In DVCS commits can be reordered, so there can be no revision with the text matching the patch context anymore.<br/><br/>Only modified files texts need to be added. Added and deleted files are self-descriptive.</html>";
        this.myBaseRevisionTextShouldLabel = new JBLabel("<html>Base revision texts are worth including into the patch, if it is about to be used in projects under DVCS.<br/>In DVCS commits can be reordered, so there can be no revision with the text matching the patch context anymore.<br/><br/>Only modified files texts need to be added. Added and deleted files are self-descriptive.</html>", UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER);
        this.myPanel.add((Component)this.myBaseRevisionTextShouldLabel, gb);
        ++gb.gridy;
        gb.fill = 1;
        gb.weighty = 1.0;
        this.myPanel.add((Component)this.myBrowser, gb);
        gb.fill = 2;
        ++gb.gridy;
        gb.weighty = 0.0;
        this.myPanel.add((Component)this.myWarningText, gb);
        return this.myPanel;
    }

    public Collection<Change> getIncludedChanges() {
        return this.myBrowser.getViewer().getIncludedChanges();
    }
}

