/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanelColumn;
import com.intellij.openapi.diff.impl.splitter.DividerPolygon;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorPlace
extends JComponent
implements Disposable,
ButtonlessScrollBarUI.ScrollbarRepaintCallback {
    private static final Logger LOG = Logger.getInstance(EditorPlace.class);
    @NotNull
    private final MergePanel2.DiffEditorState myState;
    @NotNull
    private final MergePanelColumn myColumn;
    @NotNull
    private final MergePanel2 myMergePanel;
    @NotNull
    private final List<EditorListener> myListeners;
    @Nullable
    private EditorEx myEditor;

    public EditorPlace(@NotNull MergePanel2.DiffEditorState state2, @NotNull MergePanelColumn column, @NotNull MergePanel2 mergePanel) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "<init>"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "<init>"));
        }
        if (mergePanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergePanel", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myState = state2;
        this.myColumn = column;
        this.myMergePanel = mergePanel;
        this.setLayout(new BorderLayout());
    }

    public void call(Graphics g) {
        this.paintThis(g);
    }

    private void paintThis(Graphics g) {
        if (this.myEditor == null) {
            return;
        }
        if (this.myColumn != MergePanelColumn.BASE) {
            return;
        }
        int offset = 2;
        ArrayList<DividerPolygon> polygons = DividerPolygon.createVisiblePolygons(this.myMergePanel.getSecondEditingSide(true), FragmentSide.SIDE1, offset);
        for (DividerPolygon polygon : polygons) {
            int startY = polygon.getTopLeftY();
            int endY = polygon.getBottomLeftY();
            int height = endY - startY;
            if (height == 0) {
                height = 1;
            }
            this.drawPolygon((Graphics2D)g, startY, height, polygon.getColor(), polygon.isApplied());
        }
    }

    private void drawPolygon(@NotNull Graphics2D g, int startY, int height, @NotNull Color color, boolean applied) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "drawPolygon"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "drawPolygon"));
        }
        int scrollbarWidth = this.myEditor.getScrollPane().getVerticalScrollBar().getWidth();
        int startX = 0;
        int endX = startX + scrollbarWidth - 1;
        int endY = startY + height;
        g.setColor(color);
        if (!applied) {
            if (height > 2) {
                g.fillRect(startX, startY, scrollbarWidth, height);
                Color framingColor = DiffUtil.getFramingColor(color);
                UIUtil.drawLine((Graphics2D)g, (int)startX, (int)startY, (int)endX, (int)startY, null, (Color)framingColor);
                UIUtil.drawLine((Graphics2D)g, (int)startX, (int)endY, (int)endX, (int)endY, null, (Color)framingColor);
            } else {
                DiffUtil.drawDoubleShadowedLine(g, startX, endX, startY, color);
            }
        } else {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)startX, (int)endX, (int)startY, null, (Color)color, (boolean)false);
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)startX, (int)endX, (int)endY, null, (Color)color, (boolean)false);
        }
    }

    @Override
    public void addNotify() {
        if (this.myEditor != null) {
            super.addNotify();
            return;
        }
        this.createEditor();
        super.addNotify();
        this.revalidate();
    }

    private void createEditor() {
        LOG.assertTrue(this.myEditor == null);
        this.myEditor = this.myState.createEditor();
        if (this.myEditor == null) {
            return;
        }
        this.add((Component)this.myEditor.getComponent(), "Center");
        this.myEditor.registerScrollBarRepaintCallback(this);
        this.repaint();
        this.fireEditorCreated();
    }

    public void addListener(EditorListener listener) {
        this.myListeners.add(listener);
    }

    private void fireEditorCreated() {
        for (EditorListener listener : this.myListeners) {
            listener.onEditorCreated(this);
        }
    }

    private void fireEditorReleased(Editor releasedEditor) {
        for (EditorListener listener : this.myListeners) {
            listener.onEditorReleased(releasedEditor);
        }
    }

    @Override
    public void removeNotify() {
        this.removeEditor();
        super.removeNotify();
    }

    private void removeEditor() {
        if (this.myEditor != null) {
            this.myEditor.registerScrollBarRepaintCallback(null);
            EditorEx releasedEditor = this.myEditor;
            this.remove(this.myEditor.getComponent());
            EditorPlace.getEditorFactory().releaseEditor((Editor)this.myEditor);
            this.myEditor = null;
            this.fireEditorReleased(releasedEditor);
        }
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    public void setDocument(@Nullable Document document) {
        if (document == this.getDocument()) {
            return;
        }
        this.removeEditor();
        this.myState.setDocument(document);
        this.createEditor();
    }

    private Document getDocument() {
        return this.myState.getDocument();
    }

    @NotNull
    public MergePanel2.DiffEditorState getState() {
        MergePanel2.DiffEditorState diffEditorState = this.myState;
        if (diffEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "getState"));
        }
        return diffEditorState;
    }

    private static EditorFactory getEditorFactory() {
        return EditorFactory.getInstance();
    }

    @Nullable
    public JComponent getContentComponent() {
        return this.myEditor == null ? null : this.myEditor.getContentComponent();
    }

    public void dispose() {
        this.removeEditor();
    }

    public static interface EditorListener {
        public void onEditorCreated(EditorPlace var1);

        public void onEditorReleased(Editor var1);
    }
}

