/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ChangeSide {
    public int getStart() {
        return this.getRange().getStartOffset();
    }

    public int getStartLine() {
        return DocumentUtil.getStartLine(this.getRange());
    }

    @NotNull
    public String getText() {
        String string = DocumentUtil.getText(this.getRange());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeSide", "getText"));
        }
        return string;
    }

    public int getEndLine() {
        return DocumentUtil.getEndLine(this.getRange());
    }

    @NotNull
    public abstract DiffRangeMarker getRange();

    public abstract ChangeHighlighterHolder getHighlighterHolder();

    public boolean contains(int offset) {
        return this.getStart() <= offset && offset < this.getEnd();
    }

    public int getEnd() {
        return this.getRange().getEndOffset();
    }
}

