/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.ApplicationStarterBase;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class DiffApplication
extends ApplicationStarterBase {
    public DiffApplication() {
        super("diff", 2);
    }

    @Override
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        return DiffBundle.message((String)"diff.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
    }

    @Override
    public void processCommand(String[] args, @Nullable String currentDirectory) throws ApplicationStarterBase.OperationFailedException {
        String path1 = args[1];
        String path2 = args[2];
        VirtualFile file1 = DiffApplication.findFile(path1, currentDirectory);
        VirtualFile file2 = DiffApplication.findFile(path2, currentDirectory);
        boolean areDirs = DiffApplication.areDirs(file1, file2);
        boolean areJars = DiffApplication.areJars(file1, file2);
        if (areDirs || areJars) {
            DirDiffManager diffManager = DirDiffManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
            DiffElement d1 = diffManager.createDiffElement((Object)file1);
            DiffElement d2 = diffManager.createDiffElement((Object)file2);
            if (d1 == null) {
                throw new ApplicationStarterBase.OperationFailedException(DiffBundle.message((String)"cannot.create.diff.error", (Object[])new Object[]{path1}));
            }
            if (d2 == null) {
                throw new ApplicationStarterBase.OperationFailedException(DiffBundle.message((String)"cannot.create.diff.error", (Object[])new Object[]{path1}));
            }
            if (!diffManager.canShow(d1, d2)) {
                throw new ApplicationStarterBase.OperationFailedException(DiffBundle.message((String)"cannot.compare.error", (Object[])new Object[]{path1, path2}));
            }
            DirDiffSettings settings = new DirDiffSettings();
            settings.showInFrame = false;
            diffManager.showDiff(d1, d2, settings, null);
        } else {
            file1.refresh(false, false);
            file2.refresh(false, false);
            if (file1.getFileType() == UnknownFileType.INSTANCE) {
                throw new ApplicationStarterBase.OperationFailedException(DiffBundle.message((String)"unknown.file.type.error", (Object[])new Object[]{path1}));
            }
            if (file2.getFileType() == UnknownFileType.INSTANCE) {
                throw new ApplicationStarterBase.OperationFailedException(DiffBundle.message((String)"unknown.file.type.error", (Object[])new Object[]{path2}));
            }
            SimpleDiffRequest request = SimpleDiffRequest.compareFiles((VirtualFile)file1, (VirtualFile)file2, (Project)ProjectManager.getInstance().getDefaultProject());
            request.addHint(DiffTool.HINT_SHOW_MODAL_DIALOG);
            DiffManager.getInstance().getIdeaDiffTool().show((DiffRequest)request);
        }
    }
}

