/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.store;

import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class StateStorageBase
implements StateStorage {
    protected static final Logger LOG = Logger.getInstance(StateStorageBase.class);
    private boolean mySavingDisabled = false;
    protected final TrackingPathMacroSubstitutor myPathMacroSubstitutor;

    protected StateStorageBase(@Nullable TrackingPathMacroSubstitutor trackingPathMacroSubstitutor) {
        this.myPathMacroSubstitutor = trackingPathMacroSubstitutor;
    }

    public final void disableSaving() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disabled saving for " + this.toString());
        }
        this.mySavingDisabled = true;
    }

    public final void enableSaving() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enabled saving " + this.toString());
        }
        this.mySavingDisabled = false;
    }

    protected final boolean checkIsSavingDisabled() {
        if (this.mySavingDisabled && LOG.isDebugEnabled()) {
            LOG.debug("Saving disabled for " + this.toString());
        }
        return this.mySavingDisabled;
    }
}

