/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.XmlConfigurationMerger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.iq80.snappy.SnappyInputStream;
import org.iq80.snappy.SnappyOutputStream;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageData {
    private static final Logger LOG = Logger.getInstance(StorageData.class);
    @NonNls
    public static final String COMPONENT = "component";
    @NonNls
    public static final String NAME = "name";
    private final Map<String, Object> myComponentStates;
    protected final String myRootElementName;

    public StorageData(@NotNull String rootElementName) {
        if (rootElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementName", "com/intellij/openapi/components/impl/stores/StorageData", "<init>"));
        }
        this.myComponentStates = new THashMap();
        this.myRootElementName = rootElementName;
    }

    StorageData(@NotNull StorageData storageData) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/StorageData", "<init>"));
        }
        this.myRootElementName = storageData.myRootElementName;
        this.myComponentStates = new THashMap(storageData.myComponentStates);
    }

    @NotNull
    public Set<String> getComponentNames() {
        Set<String> set = this.myComponentStates.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "getComponentNames"));
        }
        return set;
    }

    public void load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor, boolean intern) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/components/impl/stores/StorageData", "load"));
        }
        if (pathMacroSubstitutor != null) {
            pathMacroSubstitutor.expandPaths(rootElement);
        }
        Iterator iterator = rootElement.getChildren(COMPONENT).iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String name = element.getAttributeValue(NAME);
            if (StringUtil.isEmpty((String)name)) {
                LOG.warn("No name attribute for component in " + this);
                continue;
            }
            if (element.getAttributes().size() > 1 || !element.getChildren().isEmpty()) {
                Object serverElement;
                iterator.remove();
                if (intern) {
                    IdeaPluginDescriptorImpl.internJDOMElement(element);
                }
                if ((serverElement = this.myComponentStates.get(name)) != null) {
                    element = StorageData.mergeElements(name, element, (Element)serverElement);
                }
                this.myComponentStates.put(name, element);
                if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                    ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(name, PathMacrosCollector.getMacroNames(element));
                }
            }
            element.removeAttribute(NAME);
        }
    }

    @NotNull
    private static Element mergeElements(@NotNull String name, @NotNull Element localElement, @NotNull Element serverElement) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/openapi/components/impl/stores/StorageData", "mergeElements"));
        }
        if (localElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localElement", "com/intellij/openapi/components/impl/stores/StorageData", "mergeElements"));
        }
        if (serverElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverElement", "com/intellij/openapi/components/impl/stores/StorageData", "mergeElements"));
        }
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.componentConfigurationMerger");
        for (XmlConfigurationMerger merger : (XmlConfigurationMerger[])point.getExtensions()) {
            if (!merger.getComponentName().equals(name)) continue;
            Element element = merger.merge(serverElement, localElement);
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "mergeElements"));
            }
            return element;
        }
        Element element = serverElement;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "mergeElements"));
        }
        return element;
    }

    @Nullable
    protected Element save(@NotNull Map<String, Element> newLiveStates) {
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/StorageData", "save"));
        }
        if (this.myComponentStates.isEmpty()) {
            return null;
        }
        Element rootElement = new Element(this.myRootElementName);
        Object[] componentNames = ArrayUtil.toStringArray(this.myComponentStates.keySet());
        Arrays.sort(componentNames);
        for (Object componentName : componentNames) {
            Element element;
            assert (componentName != null);
            Object state2 = this.myComponentStates.get(componentName);
            if (state2 instanceof Element) {
                element = ((Element)state2).clone();
            } else {
                element = newLiveStates.get(componentName);
                if (element == null) {
                    try {
                        element = StorageData.unarchiveState((byte[])state2);
                    }
                    catch (IOException e) {
                        throw new StateStorageException((Throwable)e);
                    }
                    catch (JDOMException e) {
                        throw new StateStorageException((Throwable)e);
                    }
                }
            }
            assert (element != null);
            List elementAttributes = element.getAttributes();
            if (elementAttributes.isEmpty()) {
                element.setAttribute(NAME, (String)componentName);
            } else {
                Attribute nameAttribute = element.getAttribute(NAME);
                if (nameAttribute == null) {
                    nameAttribute = new Attribute(NAME, (String)componentName);
                    elementAttributes.add(0, nameAttribute);
                } else {
                    nameAttribute.setValue((String)componentName);
                    if (elementAttributes.get(0) != nameAttribute) {
                        elementAttributes.remove(nameAttribute);
                        elementAttributes.add(0, nameAttribute);
                    }
                }
            }
            rootElement.addContent(element.detach());
        }
        return rootElement;
    }

    @Nullable
    public Element getState(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/openapi/components/impl/stores/StorageData", "getState"));
        }
        Object state2 = this.myComponentStates.get(name);
        return state2 instanceof Element ? (Element)state2 : null;
    }

    @Nullable
    public Element getStateAndArchive(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/openapi/components/impl/stores/StorageData", "getStateAndArchive"));
        }
        Object state2 = this.myComponentStates.get(name);
        if (!(state2 instanceof Element)) {
            return null;
        }
        this.myComponentStates.put(name, StorageData.archiveState((Element)state2));
        return (Element)state2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static byte[] archiveState(@NotNull Element state2) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StorageData", "archiveState"));
        }
        BufferExposingByteArrayOutputStream byteOut = new BufferExposingByteArrayOutputStream();
        SnappyOutputStream out = null;
        try {
            try {
                out = new SnappyOutputStream((OutputStream)byteOut);
                JDOMUtil.writeParent((Parent)state2, (OutputStream)out, (String)"\n");
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new StateStorageException((Throwable)e);
        }
        byte[] byArray = ArrayUtil.realloc((byte[])byteOut.getInternalBuffer(), (int)byteOut.size());
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "archiveState"));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Element unarchiveState(@NotNull byte[] state2) throws IOException, JDOMException {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StorageData", "unarchiveState"));
        }
        InputStream in = null;
        in = new SnappyInputStream((InputStream)new ByteArrayInputStream(state2));
        Element element = JDOMUtil.loadDocument((InputStream)in).detachRootElement();
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "unarchiveState"));
        }
        return element2;
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Nullable
    static StorageData setStateAndCloneIfNeed(@NotNull String componentName, @Nullable Element newState, @NotNull StorageData storageData, @NotNull Map<String, Element> newLiveStates) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StorageData", "setStateAndCloneIfNeed"));
        }
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/StorageData", "setStateAndCloneIfNeed"));
        }
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/StorageData", "setStateAndCloneIfNeed"));
        }
        Object oldState = storageData.myComponentStates.get(componentName);
        if (newState == null || JDOMUtil.isEmpty((Element)newState)) {
            if (oldState == null) {
                return null;
            }
            StorageData newStorageData = storageData.clone();
            newStorageData.myComponentStates.remove(componentName);
            return newStorageData;
        }
        StorageData.prepareElement(newState);
        newLiveStates.put(componentName, newState);
        byte[] newBytes = null;
        if (oldState instanceof Element ? JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)newState) : oldState != null && (newBytes = StorageData.getNewByteIfDiffers(componentName, newState, (byte[])oldState)) == null) {
            return null;
        }
        StorageData newStorageData = storageData.clone();
        newStorageData.myComponentStates.put(componentName, newBytes == null ? newState : (Element)newBytes);
        return newStorageData;
    }

    @Nullable
    final Object setState(@NotNull String componentName, @Nullable Element newState, @NotNull Map<String, Element> newLiveStates) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StorageData", "setState"));
        }
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/StorageData", "setState"));
        }
        if (newState == null || JDOMUtil.isEmpty((Element)newState)) {
            return this.myComponentStates.remove(componentName);
        }
        StorageData.prepareElement(newState);
        newLiveStates.put(componentName, newState);
        Object oldState = this.myComponentStates.get(componentName);
        byte[] newBytes = null;
        if (oldState instanceof Element ? JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)newState) : oldState != null && (newBytes = StorageData.getNewByteIfDiffers(componentName, newState, (byte[])oldState)) == null) {
            return null;
        }
        this.myComponentStates.put(componentName, newBytes == null ? newState : newBytes);
        return newState;
    }

    @Nullable
    private static byte[] getNewByteIfDiffers(@NotNull String componentName, @NotNull Object newState, @NotNull byte[] oldState) {
        byte[] newBytes;
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StorageData", "getNewByteIfDiffers"));
        }
        if (newState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newState", "com/intellij/openapi/components/impl/stores/StorageData", "getNewByteIfDiffers"));
        }
        if (oldState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldState", "com/intellij/openapi/components/impl/stores/StorageData", "getNewByteIfDiffers"));
        }
        byte[] byArray = newBytes = newState instanceof Element ? StorageData.archiveState((Element)newState) : (byte[])newState;
        if (Arrays.equals(newBytes, oldState)) {
            return null;
        }
        if (LOG.isDebugEnabled() && SystemProperties.getBooleanProperty((String)"idea.log.changed.components", (boolean)false)) {
            String after;
            String before = StorageData.stateToString(oldState);
            if (before.equals(after = StorageData.stateToString(newState))) {
                LOG.debug("Serialization error: serialized are different, but unserialized are equal");
            } else {
                LOG.debug(componentName + " " + StringUtil.repeat((String)"=", (int)(80 - componentName.length())) + "\nBefore:\n" + before + "\nAfter:\n" + after);
            }
        }
        return newBytes;
    }

    @NotNull
    private static String stateToString(@NotNull Object state2) {
        Element element;
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StorageData", "stateToString"));
        }
        if (state2 instanceof Element) {
            element = (Element)state2;
        } else {
            try {
                element = StorageData.unarchiveState((byte[])state2);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                if ("internal error" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "stateToString"));
                }
                return "internal error";
            }
            catch (JDOMException e) {
                LOG.error((Throwable)e);
                if ("internal error" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "stateToString"));
                }
                return "internal error";
            }
        }
        String string = JDOMUtil.writeParent((Parent)element, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "stateToString"));
        }
        return string;
    }

    private static void prepareElement(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/StorageData", "prepareElement"));
        }
        element.setName(COMPONENT);
    }

    public StorageData clone() {
        return new StorageData(this);
    }

    public Set<String> getChangedComponentNames(@NotNull StorageData newStorageData, @Nullable PathMacroSubstitutor substitutor) {
        if (newStorageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStorageData", "com/intellij/openapi/components/impl/stores/StorageData", "getChangedComponentNames"));
        }
        SmartHashSet bothStates = new SmartHashSet(this.myComponentStates.keySet());
        bothStates.retainAll(newStorageData.myComponentStates.keySet());
        SmartHashSet diffs = new SmartHashSet();
        diffs.addAll(newStorageData.myComponentStates.keySet());
        diffs.addAll(this.myComponentStates.keySet());
        diffs.removeAll((Collection<?>)bothStates);
        for (String componentName : bothStates) {
            Object oldState = this.myComponentStates.get(componentName);
            Object newState = newStorageData.myComponentStates.get(componentName);
            if (oldState instanceof Element) {
                if (JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)((Element)newState))) continue;
                diffs.add(componentName);
                continue;
            }
            if (StorageData.getNewByteIfDiffers(componentName, newState, (byte[])oldState) == null) continue;
            diffs.add(componentName);
        }
        return diffs;
    }

    public boolean hasState(@NotNull String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StorageData", "hasState"));
        }
        return this.myComponentStates.get(componentName) instanceof Element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Element load(@NotNull VirtualFile file) throws IOException, JDOMException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StorageData", "load"));
        }
        InputStream stream = file.getInputStream();
        Element element = JDOMUtil.loadDocument((InputStream)stream).getRootElement();
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "load"));
        }
        return element2;
        finally {
            stream.close();
        }
    }
}

