/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.DirectoryBasedStorage;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.OldStreamProviderAdapter;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.CurrentUserHolder;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.RoamingTypeDisabled;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.TObjectLongHashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public abstract class StateStorageManagerImpl
implements StateStorageManager,
Disposable,
ComponentVersionProvider {
    private static final Logger LOG = Logger.getInstance(StateStorageManagerImpl.class);
    private static final boolean ourHeadlessEnvironment;
    private final Map<String, String> myMacros = new LinkedHashMap<String, String>();
    private final Lock myStorageLock = new ReentrantLock();
    private final Map<String, StateStorage> myStorages = new THashMap();
    private final Map<String, StateStorage> myPathToStorage = new THashMap();
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;
    private final String myRootTagName;
    private final PicoContainer myPicoContainer;
    private TObjectLongHashMap<String> myComponentVersions;
    private final Object myComponentVersionsLock = new Object();
    private String myVersionsFilePath;
    private boolean isDirty;
    private StreamProvider myStreamProvider;
    private final OldStreamProviderManager myOldStreamProvider = new OldStreamProviderManager();
    private static final Pattern MACRO_PATTERN;

    public StateStorageManagerImpl(@Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, String rootTagName, @Nullable Disposable parentDisposable, PicoContainer picoContainer) {
        this.myPicoContainer = picoContainer;
        this.myRootTagName = rootTagName;
        this.myPathMacroSubstitutor = pathMacroSubstitutor;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    @Override
    public TrackingPathMacroSubstitutor getMacroSubstitutor() {
        return this.myPathMacroSubstitutor;
    }

    @Override
    public synchronized void addMacro(@NotNull String macro, @NotNull String expansion) {
        if (macro == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macro", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "addMacro"));
        }
        if (expansion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expansion", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "addMacro"));
        }
        assert (!macro.isEmpty());
        if (macro.charAt(0) != '$') {
            LOG.warn("Add macros instead of macro name: " + macro);
            expansion = '$' + macro + '$';
        }
        this.myMacros.put(macro, expansion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StateStorage getStateStorage(@NotNull Storage storageSpec) {
        if (storageSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStateStorage"));
        }
        String key = StateStorageManagerImpl.getStorageSpecId(storageSpec);
        this.myStorageLock.lock();
        try {
            StateStorage stateStorage = this.myStorages.get(key);
            if (stateStorage == null) {
                stateStorage = this.createStateStorage(storageSpec);
                this.putStorageToMap(key, stateStorage);
            }
            StateStorage stateStorage2 = stateStorage;
            return stateStorage2;
        }
        finally {
            this.myStorageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StateStorage getStateStorage(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStateStorage"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStateStorage"));
        }
        this.myStorageLock.lock();
        try {
            StateStorage stateStorage = this.myStorages.get(fileSpec);
            if (stateStorage == null) {
                stateStorage = this.createFileStateStorage(fileSpec, roamingType);
                this.putStorageToMap(fileSpec, stateStorage);
            }
            StateStorage stateStorage2 = stateStorage;
            return stateStorage2;
        }
        finally {
            this.myStorageLock.unlock();
        }
    }

    @Override
    @Nullable
    public StateStorage getFileStateStorage(@NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getFileStateStorage"));
        }
        return this.getStateStorage(fileSpec, RoamingType.PER_USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Couple<Collection<FileBasedStorage>> getCachedFileStateStorages(@NotNull Collection<String> changed, @NotNull Collection<String> deleted) {
        if (changed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStateStorages"));
        }
        if (deleted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleted", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStateStorages"));
        }
        this.myStorageLock.lock();
        Couple couple = Couple.of(this.getCachedFileStorages(changed), this.getCachedFileStorages(deleted));
        Couple couple2 = couple;
        if (couple2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStateStorages"));
        }
        return couple2;
        finally {
            this.myStorageLock.unlock();
        }
    }

    @NotNull
    private Collection<FileBasedStorage> getCachedFileStorages(@NotNull Collection<String> fileSpecs) {
        if (fileSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpecs", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStorages"));
        }
        if (fileSpecs.isEmpty()) {
            List<FileBasedStorage> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStorages"));
            }
            return list;
        }
        SmartList result = null;
        for (String fileSpec : fileSpecs) {
            StateStorage storage = this.myStorages.get(fileSpec);
            if (!(storage instanceof FileBasedStorage)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add((FileBasedStorage)storage);
        }
        List<FileBasedStorage> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStorages"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Collection<String> getStorageFileNames() {
        this.myStorageLock.lock();
        if (this.myStorages.isEmpty()) {
            List<String> list = Collections.emptyList();
            List<String> list2 = list;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStorageFileNames"));
            }
            return list2;
        }
        Collection<String> collection = Collections.unmodifiableCollection(this.myStorages.keySet());
        Collection<String> collection2 = collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStorageFileNames"));
        }
        return collection2;
        finally {
            this.myStorageLock.unlock();
        }
    }

    private void putStorageToMap(String key, StateStorage stateStorage) {
        if (stateStorage != null) {
            if (stateStorage instanceof FileBasedStorage) {
                String filePath = ((FileBasedStorage)stateStorage).getFilePath();
                if (this.myPathToStorage.containsKey(filePath)) {
                    StateStorage existing = this.myPathToStorage.get(filePath);
                    this.myStorages.put(key, existing);
                } else {
                    this.myPathToStorage.put(filePath, stateStorage);
                    this.myStorages.put(key, stateStorage);
                }
            } else {
                this.myStorages.put(key, stateStorage);
            }
        }
    }

    @Nullable
    private StateStorage createStateStorage(Storage storageSpec) {
        if (!storageSpec.storageClass().equals(StateStorage.class)) {
            String key = UUID.randomUUID().toString();
            ((MutablePicoContainer)this.myPicoContainer).registerComponentImplementation((Object)key, storageSpec.storageClass());
            return (StateStorage)this.myPicoContainer.getComponentInstance((Object)key);
        }
        if (!storageSpec.stateSplitter().equals(StateSplitter.class)) {
            return this.createDirectoryStateStorage(storageSpec.file(), storageSpec.stateSplitter());
        }
        return this.createFileStateStorage(storageSpec.file(), storageSpec.roamingType());
    }

    private static String getStorageSpecId(Storage storageSpec) {
        if (!storageSpec.storageClass().equals(StateStorage.class)) {
            return storageSpec.storageClass().getName();
        }
        return storageSpec.file();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStateStorage(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "clearStateStorage"));
        }
        this.myStorageLock.lock();
        try {
            this.myStorages.remove(file);
        }
        finally {
            this.myStorageLock.unlock();
        }
    }

    @Nullable
    private StateStorage createDirectoryStateStorage(String file, Class<? extends StateSplitter> splitterClass) {
        StateSplitter splitter = (StateSplitter)ReflectionUtil.newInstance(splitterClass, (Class[])new Class[0]);
        return new DirectoryBasedStorage(this.myPathMacroSubstitutor, this.expandMacros(file), splitter, this, this.createStorageTopicListener());
    }

    @Nullable
    private StateStorage createFileStateStorage(@NotNull String fileSpec, @Nullable RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "createFileStateStorage"));
        }
        String expandedFile = this.expandMacros(fileSpec);
        if (!ourHeadlessEnvironment && PathUtilRt.getFileName((String)expandedFile).lastIndexOf(46) < 0) {
            throw new IllegalArgumentException("Extension is missing for storage file: " + expandedFile);
        }
        if (roamingType != RoamingType.PER_USER && fileSpec.equals("$WORKSPACE_FILE$")) {
            roamingType = RoamingType.DISABLED;
        }
        this.beforeFileBasedStorageCreate();
        return new FileBasedStorage(expandedFile, fileSpec, roamingType, this.getMacroSubstitutor(fileSpec), this.myRootTagName, this, this.createStorageTopicListener(), this.getStreamProvider(), this){

            @Override
            @NotNull
            protected StorageData createStorageData() {
                StorageData storageData = StateStorageManagerImpl.this.createStorageData(this.myFileSpec);
                if (storageData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$1", "createStorageData"));
                }
                return storageData;
            }

            @Override
            protected boolean isUseXmlProlog() {
                return StateStorageManagerImpl.this.isUseXmlProlog();
            }
        };
    }

    @Nullable
    protected StateStorage.Listener createStorageTopicListener() {
        MessageBus messageBus = (MessageBus)this.myPicoContainer.getComponentInstanceOfType(MessageBus.class);
        return messageBus == null ? null : (StateStorage.Listener)messageBus.syncPublisher(StateStorage.STORAGE_TOPIC);
    }

    protected boolean isUseXmlProlog() {
        return true;
    }

    protected void beforeFileBasedStorageCreate() {
    }

    @Override
    public long getVersion(String name) {
        return this.getComponentVersions().get((Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeVersionsFilePath(String newPath) {
        this.myVersionsFilePath = newPath;
        Object object = this.myComponentVersionsLock;
        synchronized (object) {
            this.myComponentVersions = null;
        }
        this.isDirty = false;
    }

    private TObjectLongHashMap<String> loadVersions() {
        TObjectLongHashMap result = new TObjectLongHashMap();
        String filePath = this.getNotNullVersionsFilePath();
        if (filePath != null) {
            try {
                StateStorageManagerImpl.loadComponentVersions((TObjectLongHashMap<String>)result, JDOMUtil.loadDocument((File)new File(filePath)));
            }
            catch (JDOMException e) {
                LOG.debug((Throwable)e);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return result;
    }

    private String getNotNullVersionsFilePath() {
        if (this.myVersionsFilePath == null) {
            this.myVersionsFilePath = this.getVersionsFilePath();
        }
        return this.myVersionsFilePath;
    }

    public static void loadComponentVersions(TObjectLongHashMap<String> result, Document document) {
        List componentObjects = document.getRootElement().getChildren("component");
        result.ensureCapacity(componentObjects.size());
        for (Element component : componentObjects) {
            String name = component.getAttributeValue("name");
            String version = component.getAttributeValue("version");
            if (name == null || version == null) continue;
            try {
                result.put((Object)name, Long.parseLong(version));
            }
            catch (NumberFormatException ignored) {}
        }
    }

    protected abstract String getVersionsFilePath();

    @Override
    public void changeVersion(String name, long version) {
        this.getComponentVersions().put((Object)name, version);
        this.isDirty = true;
    }

    @Override
    @Nullable
    public StreamProvider getStreamProvider() {
        return (StreamProvider)ObjectUtils.chooseNotNull((Object)this.myStreamProvider, (Object)this.myOldStreamProvider);
    }

    protected TrackingPathMacroSubstitutor getMacroSubstitutor(@NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getMacroSubstitutor"));
        }
        return this.myPathMacroSubstitutor;
    }

    protected abstract StorageData createStorageData(@NotNull String var1);

    @Override
    @NotNull
    public synchronized String expandMacros(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "expandMacros"));
        }
        Matcher matcher = MACRO_PATTERN.matcher(file);
        while (matcher.find()) {
            String m = matcher.group(1);
            if (this.myMacros.containsKey(m)) continue;
            throw new IllegalArgumentException("Unknown macro: " + m + " in storage file spec: " + file);
        }
        String expanded = file;
        for (String macro : this.myMacros.keySet()) {
            expanded = StringUtil.replace((String)expanded, (String)macro, (String)this.myMacros.get(macro));
        }
        String string = expanded;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "expandMacros"));
        }
        return string;
    }

    @Override
    @NotNull
    public String collapseMacros(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "collapseMacros"));
        }
        String result = path;
        for (String macro : this.myMacros.keySet()) {
            result = StringUtil.replace((String)result, (String)this.myMacros.get(macro), (String)macro);
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "collapseMacros"));
        }
        return string;
    }

    @Override
    @NotNull
    public StateStorageManager.ExternalizationSession startExternalization() {
        StateStorageManagerExternalizationSession stateStorageManagerExternalizationSession = new StateStorageManagerExternalizationSession();
        if (stateStorageManagerExternalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "startExternalization"));
        }
        return stateStorageManagerExternalizationSession;
    }

    @Override
    @Nullable
    public StateStorage.SaveSession startSave(@NotNull StateStorageManager.ExternalizationSession externalizationSession) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizationSession", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "startSave"));
        }
        return ((StateStorageManagerExternalizationSession)externalizationSession).createSaveSession();
    }

    @Override
    public void finishSave(@NotNull StateStorage.SaveSession saveSession) {
        if (saveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveSession", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "finishSave"));
        }
        if (!this.isDirty) {
            return;
        }
        String filePath = this.getNotNullVersionsFilePath();
        if (filePath != null) {
            File file = new File(filePath);
            FileUtilRt.createParentDirs((File)file);
            try {
                JDOMUtil.writeParent((Parent)StateStorageManagerImpl.createComponentVersionsXml(this.getComponentVersions()), (File)file, (String)"\n");
                this.isDirty = false;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public StateStorage getOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getOldStorage"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getOldStorage"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getOldStorage"));
        }
        String oldStorageSpec = this.getOldStorageSpec(component, componentName, operation);
        return oldStorageSpec == null ? null : this.getStateStorage(oldStorageSpec, component instanceof RoamingTypeDisabled ? RoamingType.DISABLED : RoamingType.PER_USER);
    }

    @Nullable
    protected abstract String getOldStorageSpec(@NotNull Object var1, @NotNull String var2, @NotNull StateStorageOperation var3);

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStreamProvider(com.intellij.openapi.options.StreamProvider streamProvider, RoamingType type) {
        OldStreamProviderManager oldStreamProviderManager = this.myOldStreamProvider;
        synchronized (oldStreamProviderManager) {
            this.myOldStreamProvider.myStreamProviders.add(new OldStreamProviderAdapter(streamProvider, type));
        }
    }

    @Override
    public void setStreamProvider(@Nullable StreamProvider streamProvider) {
        this.myStreamProvider = streamProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TObjectLongHashMap<String> getComponentVersions() {
        Object object = this.myComponentVersionsLock;
        synchronized (object) {
            if (this.myComponentVersions == null) {
                this.myComponentVersions = this.loadVersions();
            }
            return this.myComponentVersions;
        }
    }

    public static Element createComponentVersionsXml(TObjectLongHashMap<String> versions) {
        Element root = new Element("versions");
        Object[] componentNames = versions.keys();
        Arrays.sort(componentNames);
        for (Object key : componentNames) {
            String name = (String)key;
            long version = versions.get((Object)name);
            if (version == 0L) continue;
            Element element = new Element("component");
            root.addContent(element);
            element.setAttribute("name", name);
            element.setAttribute("version", String.valueOf(version));
        }
        return root;
    }

    static {
        Application app = ApplicationManager.getApplication();
        ourHeadlessEnvironment = app.isHeadlessEnvironment() || app.isUnitTestMode();
        MACRO_PATTERN = Pattern.compile("(\\$[^\\$]*\\$)");
    }

    private static class OldStreamProviderManager
    extends StreamProvider
    implements CurrentUserHolder {
        private final List<OldStreamProviderAdapter> myStreamProviders = new SmartList();

        private OldStreamProviderManager() {
        }

        @Override
        public boolean isVersioningRequired() {
            return true;
        }

        @Override
        public boolean isEnabled() {
            for (OldStreamProviderAdapter provider : this.myStreamProviders) {
                if (!((StreamProvider)provider).isEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            if (fileSpec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "isApplicable"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "isApplicable"));
            }
            for (OldStreamProviderAdapter provider : this.myStreamProviders) {
                if (!((StreamProvider)provider).isApplicable(fileSpec, roamingType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void saveContent(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType, boolean async) throws IOException {
            if (fileSpec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "saveContent"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "saveContent"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "saveContent"));
            }
            for (OldStreamProviderAdapter streamProvider : this.myStreamProviders) {
                try {
                    if (!((StreamProvider)streamProvider).isEnabled() || !((StreamProvider)streamProvider).isApplicable(fileSpec, roamingType)) continue;
                    ((StreamProvider)streamProvider).saveContent(fileSpec, content, size, roamingType, async);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
        }

        @Override
        public InputStream loadContent(@NotNull String fileSpec, @NotNull RoamingType roamingType) throws IOException {
            if (fileSpec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "loadContent"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "loadContent"));
            }
            for (OldStreamProviderAdapter streamProvider : this.myStreamProviders) {
                try {
                    InputStream content;
                    if (!((StreamProvider)streamProvider).isEnabled() || !((StreamProvider)streamProvider).isApplicable(fileSpec, roamingType) || (content = ((StreamProvider)streamProvider).loadContent(fileSpec, roamingType)) == null) continue;
                    return content;
                }
                catch (ConnectException e) {
                    LOG.debug("Cannot send user profile o server: " + e.getLocalizedMessage());
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
            return null;
        }

        @Override
        public void delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            if (fileSpec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "delete"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "delete"));
            }
            for (OldStreamProviderAdapter streamProvider : this.myStreamProviders) {
                try {
                    if (!((StreamProvider)streamProvider).isEnabled() || !((StreamProvider)streamProvider).isApplicable(fileSpec, roamingType)) continue;
                    ((StreamProvider)streamProvider).delete(fileSpec, roamingType);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
        }

        public String getCurrentUserName() {
            for (OldStreamProviderAdapter provider : this.myStreamProviders) {
                String userName;
                if (!provider.isEnabled() || (userName = provider.getCurrentUserName()) == null) continue;
                return userName;
            }
            return null;
        }
    }

    private static final class StateStorageSaveSession
    implements StateStorage.SaveSession {
        private final List<StateStorage.SaveSession> mySaveSessions;

        public StateStorageSaveSession(@NotNull List<StateStorage.SaveSession> saveSessions) {
            if (saveSessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveSessions", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageSaveSession", "<init>"));
            }
            this.mySaveSessions = saveSessions;
        }

        public void save() {
            for (StateStorage.SaveSession saveSession : this.mySaveSessions) {
                saveSession.save();
            }
        }
    }

    protected class StateStorageManagerExternalizationSession
    implements StateStorageManager.ExternalizationSession {
        final Map<StateStorage, StateStorage.ExternalizationSession> mySessions = new LinkedHashMap<StateStorage, StateStorage.ExternalizationSession>();

        protected StateStorageManagerExternalizationSession() {
        }

        @Override
        public void setState(@NotNull Storage[] storageSpecs, @NotNull Object component, @NotNull String componentName, @NotNull Object state2) {
            if (storageSpecs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageSpecs", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setState"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setState"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setState"));
            }
            if (state2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setState"));
            }
            for (Storage storageSpec : storageSpecs) {
                StateStorage.ExternalizationSession session;
                StateStorage stateStorage = StateStorageManagerImpl.this.getStateStorage(storageSpec);
                if (stateStorage == null || (session = this.getExternalizationSession(stateStorage)) == null) continue;
                session.setState(component, componentName, storageSpec.deprecated() ? new Element("empty") : state2, storageSpec);
            }
        }

        @Override
        public void setStateInOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull Object state2) {
            StateStorage.ExternalizationSession session;
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setStateInOldStorage"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setStateInOldStorage"));
            }
            if (state2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setStateInOldStorage"));
            }
            StateStorage stateStorage = StateStorageManagerImpl.this.getOldStorage(component, componentName, StateStorageOperation.WRITE);
            if (stateStorage != null && (session = this.getExternalizationSession(stateStorage)) != null) {
                session.setState(component, componentName, state2, null);
            }
        }

        @Nullable
        private StateStorage.ExternalizationSession getExternalizationSession(@NotNull StateStorage stateStorage) {
            if (stateStorage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStorage", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "getExternalizationSession"));
            }
            StateStorage.ExternalizationSession session = this.mySessions.get(stateStorage);
            if (session == null && (session = stateStorage.startExternalization()) != null) {
                this.mySessions.put(stateStorage, session);
            }
            return session;
        }

        @Nullable
        public StateStorage.SaveSession createSaveSession() {
            if (this.mySessions.isEmpty()) {
                return null;
            }
            List saveSessions = null;
            for (Map.Entry<StateStorage, StateStorage.ExternalizationSession> entry : this.mySessions.entrySet()) {
                StateStorage.SaveSession saveSession = entry.getKey().startSave(entry.getValue());
                if (saveSession == null) continue;
                if (saveSessions == null) {
                    saveSessions = new SmartList();
                }
                saveSessions.add(saveSession);
            }
            return saveSessions == null ? null : new StateStorageSaveSession(saveSessions);
        }
    }
}

