/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryStorageData {
    private static final Logger LOG = Logger.getInstance(DirectoryStorageData.class);
    private Map<String, THashMap<File, Element>> myStates = new THashMap();
    private long myLastTimestamp = 0L;
    private DirectoryStorageData myOriginalData;

    @NotNull
    public Set<String> getComponentNames() {
        Set<String> set = this.myStates.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "getComponentNames"));
        }
        return set;
    }

    static boolean isStorageFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "isStorageFile"));
        }
        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)".xml");
    }

    public void loadFrom(@Nullable VirtualFile dir, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor) {
        if (dir == null || !dir.exists()) {
            return;
        }
        for (VirtualFile file : dir.getChildren()) {
            if (!DirectoryStorageData.isStorageFile(file)) continue;
            try {
                Element element = JDOMUtil.loadDocument((byte[])file.contentsToByteArray()).detachRootElement();
                if (!element.getName().equals("component")) {
                    LOG.error("Incorrect root tag name (" + element.getName() + ") in " + file.getPresentableUrl());
                    continue;
                }
                String componentName = element.getAttributeValue("name");
                if (componentName == null) {
                    LOG.error("Component name isn't specified in " + file.getPresentableUrl());
                    continue;
                }
                if (pathMacroSubstitutor != null) {
                    pathMacroSubstitutor.expandPaths(element);
                    pathMacroSubstitutor.addUnknownMacros(componentName, PathMacrosCollector.getMacroNames(element));
                }
                this.put(componentName, new File(file.getPath()), element, true);
            }
            catch (IOException e) {
                LOG.info("Unable to load state", (Throwable)e);
            }
            catch (JDOMException e) {
                LOG.info("Unable to load state", (Throwable)e);
            }
        }
    }

    public void put(@NotNull String componentName, @NotNull File file, @NotNull Element element, boolean updateTimestamp) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "put"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "put"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "put"));
        }
        THashMap stateMap = this.myStates.get(componentName);
        if (stateMap == null) {
            stateMap = new THashMap();
            this.myStates.put(componentName, (THashMap<File, Element>)stateMap);
        }
        stateMap.put((Object)file, (Object)element);
        if (updateTimestamp) {
            this.updateLastTimestamp(file);
        }
    }

    public void updateLastTimestamp(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "updateLastTimestamp"));
        }
        this.myLastTimestamp = Math.max(this.myLastTimestamp, file.lastModified());
        if (this.myOriginalData != null) {
            this.myOriginalData.myLastTimestamp = this.myLastTimestamp;
        }
    }

    public long getLastTimeStamp() {
        return this.myLastTimestamp;
    }

    void processComponent(@NotNull String componentName, @NotNull TObjectObjectProcedure<File, Element> consumer) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "processComponent"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "processComponent"));
        }
        THashMap<File, Element> map = this.myStates.get(componentName);
        if (map != null) {
            map.forEachEntry(consumer);
        }
    }

    protected DirectoryStorageData clone() {
        DirectoryStorageData result = new DirectoryStorageData();
        result.myStates = new THashMap(this.myStates);
        result.myLastTimestamp = this.myLastTimestamp;
        result.myOriginalData = this;
        return result;
    }

    public void clear() {
        this.myStates.clear();
        this.myOriginalData = null;
    }

    public boolean containsComponent(String componentName) {
        return this.myStates.get(componentName) != null;
    }

    public void removeComponent(String componentName) {
        this.myStates.remove(componentName);
    }

    @Nullable
    public <T> T getMergedState(String componentName, Class<T> stateClass, StateSplitter splitter, @Nullable T mergeInto) {
        final ArrayList subElements = new ArrayList();
        this.processComponent(componentName, new TObjectObjectProcedure<File, Element>(){

            public boolean execute(File file, Element element) {
                List children = element.getChildren();
                assert (children.size() == 1) : JDOMUtil.writeElement((Element)element, (String)File.separator);
                Element subElement = (Element)children.get(0);
                subElement.detach();
                subElements.add(subElement);
                return true;
            }
        });
        Element state2 = new Element("component");
        splitter.mergeStatesInto(state2, subElements.toArray(new Element[subElements.size()]));
        this.removeComponent(componentName);
        return DefaultStateSerializer.deserializeState(state2, stateClass, mergeInto);
    }
}

