/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.ProjectStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Couple;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultProjectStoreImpl
extends ProjectStoreImpl {
    private final ProjectManagerImpl myProjectManager;
    @NonNls
    private static final String ROOT_TAG_NAME = "defaultProject";

    public DefaultProjectStoreImpl(@NotNull ProjectImpl project, @NotNull ProjectManagerImpl projectManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl", "<init>"));
        }
        if (projectManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectManager", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl", "<init>"));
        }
        super(project);
        this.myProjectManager = projectManager;
    }

    @Nullable
    Element getStateCopy() {
        Element element = this.myProjectManager.getDefaultProjectRootElement();
        return element != null ? element.clone() : null;
    }

    @Override
    @NotNull
    protected StateStorageManager createStateStorageManager() {
        ComponentManager componentManager = this.getComponentManager();
        final XmlElementStorage storage = new XmlElementStorage("", RoamingType.DISABLED, PathMacroManager.getInstance(componentManager).createTrackingSubstitutor(), ROOT_TAG_NAME, null, ComponentVersionProvider.EMPTY){

            @Override
            @Nullable
            protected Element loadLocalData() {
                return DefaultProjectStoreImpl.this.getStateCopy();
            }

            @Override
            protected XmlElementStorage.XmlElementStorageSaveSession createSaveSession(@NotNull StorageData storageData) {
                if (storageData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$1", "createSaveSession"));
                }
                return new XmlElementStorage.XmlElementStorageSaveSession(storageData){

                    @Override
                    protected void doSave(@Nullable Element element) {
                        DefaultProjectStoreImpl.this.myProjectManager.setDefaultProjectRootElement(element == null ? new Element("empty") : element);
                    }

                    @Override
                    protected boolean isCollapsePathsOnSave() {
                        return false;
                    }
                };
            }

            @Override
            @NotNull
            protected StorageData createStorageData() {
                BaseFileConfigurableStoreImpl.BaseStorageData baseStorageData = new BaseFileConfigurableStoreImpl.BaseStorageData(DefaultProjectStoreImpl.ROOT_TAG_NAME);
                if (baseStorageData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$1", "createStorageData"));
                }
                return baseStorageData;
            }
        };
        StateStorageManager stateStorageManager = new StateStorageManager(){

            @Override
            public void addMacro(@NotNull String macro, @NotNull String expansion) {
                if (macro == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macro", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "addMacro"));
                }
                if (expansion == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expansion", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "addMacro"));
                }
                throw new UnsupportedOperationException("Method addMacro not implemented in " + this.getClass());
            }

            @Override
            @Nullable
            public TrackingPathMacroSubstitutor getMacroSubstitutor() {
                return null;
            }

            @Override
            @Nullable
            public StateStorage getStateStorage(@NotNull Storage storageSpec) throws StateStorageException {
                if (storageSpec == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageSpec", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getStateStorage"));
                }
                return storage;
            }

            @Override
            @Nullable
            public StateStorage getStateStorage(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
                if (fileSpec == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getStateStorage"));
                }
                if (roamingType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getStateStorage"));
                }
                return storage;
            }

            @Override
            @NotNull
            public Couple<Collection<FileBasedStorage>> getCachedFileStateStorages(@NotNull Collection<String> changed, @NotNull Collection<String> deleted) {
                if (changed == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getCachedFileStateStorages"));
                }
                if (deleted == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleted", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getCachedFileStateStorages"));
                }
                Couple couple = new Couple(Collections.emptyList(), Collections.emptyList());
                if (couple == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getCachedFileStateStorages"));
                }
                return couple;
            }

            @Override
            @Nullable
            public StateStorage getFileStateStorage(@NotNull String fileSpec) {
                if (fileSpec == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getFileStateStorage"));
                }
                return storage;
            }

            @Override
            public void clearStateStorage(@NotNull String file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "clearStateStorage"));
                }
            }

            @Override
            @Nullable
            public StateStorageManager.ExternalizationSession startExternalization() {
                XmlElementStorage.XmlElementStorageSaveSession externalizationSession = storage.startExternalization();
                return externalizationSession == null ? null : new MyExternalizationSession(externalizationSession);
            }

            @Override
            @Nullable
            public StateStorage.SaveSession startSave(@NotNull StateStorageManager.ExternalizationSession externalizationSession) {
                if (externalizationSession == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizationSession", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "startSave"));
                }
                return storage.startSave(((MyExternalizationSession)externalizationSession).externalizationSession);
            }

            @Override
            public void finishSave(@NotNull StateStorage.SaveSession saveSession) {
                if (saveSession == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveSession", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "finishSave"));
                }
            }

            @Override
            @NotNull
            public String expandMacros(@NotNull String file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "expandMacros"));
                }
                throw new UnsupportedOperationException("Method expandMacros not implemented in " + this.getClass());
            }

            @Override
            @NotNull
            public String collapseMacros(@NotNull String path) {
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "collapseMacros"));
                }
                throw new UnsupportedOperationException("Method collapseMacros not implemented in " + this.getClass());
            }

            @Override
            @Nullable
            public StateStorage getOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getOldStorage"));
                }
                if (componentName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getOldStorage"));
                }
                if (operation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getOldStorage"));
                }
                return storage;
            }

            @Override
            public void registerStreamProvider(com.intellij.openapi.options.StreamProvider streamProvider, RoamingType type) {
                throw new UnsupportedOperationException("Method registerStreamProvider not implemented in " + this.getClass());
            }

            @Override
            public void setStreamProvider(@Nullable StreamProvider streamProvider) {
                throw new UnsupportedOperationException("Method setStreamProvider not implemented in " + this.getClass());
            }

            @Override
            @Nullable
            public StreamProvider getStreamProvider() {
                throw new UnsupportedOperationException("Method getStreamProviders not implemented in " + this.getClass());
            }

            @Override
            @NotNull
            public Collection<String> getStorageFileNames() {
                throw new UnsupportedOperationException("Method getStorageFileNames not implemented in " + this.getClass());
            }
        };
        if (stateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl", "createStateStorageManager"));
        }
        return stateStorageManager;
    }

    @Override
    public void load() throws IOException, StateStorageException {
        if (this.myProjectManager.getDefaultProjectRootElement() == null) {
            return;
        }
        super.load();
    }

    private static class MyExternalizationSession
    implements StateStorageManager.ExternalizationSession {
        @NotNull
        final StateStorage.ExternalizationSession externalizationSession;

        public MyExternalizationSession(@NotNull StateStorage.ExternalizationSession externalizationSession) {
            if (externalizationSession == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizationSession", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "<init>"));
            }
            this.externalizationSession = externalizationSession;
        }

        @Override
        public void setState(@NotNull Storage[] storageSpecs, @NotNull Object component, @NotNull String componentName, @NotNull Object state2) {
            if (storageSpecs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageSpecs", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setState"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setState"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setState"));
            }
            if (state2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setState"));
            }
            this.externalizationSession.setState(component, componentName, state2, null);
        }

        @Override
        public void setStateInOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull Object state2) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setStateInOldStorage"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setStateInOldStorage"));
            }
            if (state2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setStateInOldStorage"));
            }
            this.externalizationSession.setState(component, componentName, state2, null);
        }
    }
}

