/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CompressionUtil;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorChangeAction
extends BasicUndoableAction {
    private final int myOffset;
    private final Object myOldString;
    private final Object myNewString;
    private final long myOldTimeStamp;
    private final long myNewTimeStamp;
    @NotNull
    private final Charset myCharset;

    public EditorChangeAction(DocumentEvent e) {
        this((DocumentEx)e.getDocument(), e.getOffset(), e.getOldFragment(), e.getNewFragment(), e.getOldTimeStamp());
    }

    public EditorChangeAction(@NotNull DocumentEx document, int offset, CharSequence oldString, CharSequence newString, long oldTimeStamp) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/command/impl/EditorChangeAction", "<init>"));
        }
        super(new Document[]{document});
        Charset charset = EncodingManager.getInstance().getEncoding(FileDocumentManager.getInstance().getFile((Document)document), true);
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        this.myCharset = charset;
        this.myOffset = offset;
        this.myOldString = oldString == null ? "" : CompressionUtil.compressCharSequence(oldString, this.myCharset);
        this.myNewString = newString == null ? "" : CompressionUtil.compressCharSequence(newString, this.myCharset);
        this.myOldTimeStamp = oldTimeStamp;
        this.myNewTimeStamp = document.getModificationStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        DocumentUndoProvider.startDocumentUndo(this.getDocument());
        try {
            this.performUndo();
        }
        finally {
            DocumentUndoProvider.finishDocumentUndo(this.getDocument());
        }
        this.getDocument().setModificationStamp(this.myOldTimeStamp);
        this.refreshFileStatus();
    }

    public void performUndo() {
        this.exchangeStrings(CompressionUtil.uncompressCharSequence(this.myNewString, this.myCharset), CompressionUtil.uncompressCharSequence(this.myOldString, this.myCharset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        DocumentUndoProvider.startDocumentUndo(this.getDocument());
        try {
            this.exchangeStrings(CompressionUtil.uncompressCharSequence(this.myOldString, this.myCharset), CompressionUtil.uncompressCharSequence(this.myNewString, this.myCharset));
        }
        finally {
            DocumentUndoProvider.finishDocumentUndo(this.getDocument());
        }
        this.getDocument().setModificationStamp(this.myNewTimeStamp);
        this.refreshFileStatus();
    }

    private void exchangeStrings(CharSequence newString, CharSequence oldString) {
        DocumentEx d = this.getDocument();
        if (newString.length() > 0 && oldString.length() == 0) {
            d.deleteString(this.myOffset, this.myOffset + newString.length());
        } else if (oldString.length() > 0 && newString.length() == 0) {
            d.insertString(this.myOffset, oldString);
        } else if (oldString.length() > 0 && newString.length() > 0) {
            d.replaceString(this.myOffset, this.myOffset + newString.length(), oldString);
        }
    }

    private void refreshFileStatus() {
        VirtualFile f = this.getAffectedDocuments()[0].getFile();
        if (f == null || f instanceof LightVirtualFile) {
            return;
        }
        for (Project each : ProjectManager.getInstance().getOpenProjects()) {
            FileStatusManagerImpl statusManager = (FileStatusManagerImpl)FileStatusManager.getInstance((Project)each);
            statusManager.refreshFileStatusFromDocument(f, this.getDocument());
        }
    }

    private DocumentEx getDocument() {
        return (DocumentEx)this.getAffectedDocuments()[0].getDocument();
    }

    @NonNls
    public String toString() {
        return "editor change: '" + this.myOldString + "' to '" + this.myNewString + "'" + " at: " + this.myOffset;
    }
}

