/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class IdeaActionButtonLook
extends ActionButtonLook {
    private static final Color ALPHA_20 = Gray._0.withAlpha(20);
    private static final Color ALPHA_30 = Gray._0.withAlpha(30);
    private static final Color ALPHA_40 = Gray._0.withAlpha(40);
    private static final Color ALPHA_120 = Gray._0.withAlpha(120);
    private static final BasicStroke BASIC_STROKE = new BasicStroke();

    @Override
    public void paintBackground(Graphics g, JComponent component, int state2) {
        if (state2 != 0) {
            this.paintBackground(g, component.getSize(), state2);
        }
    }

    protected void paintBackground(Graphics g, Dimension size, int state2) {
        if (UIUtil.isUnderAquaLookAndFeel()) {
            if (state2 == -1) {
                ((Graphics2D)g).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)ALPHA_40, (float)size.width, (float)size.height, (Color)ALPHA_20));
                g.fillRect(0, 0, size.width - 1, size.height - 1);
                g.setColor(ALPHA_120);
                g.drawLine(0, 0, 0, size.height - 2);
                g.drawLine(1, 0, size.width - 2, 0);
                g.setColor(ALPHA_30);
                g.drawRect(1, 1, size.width - 3, size.height - 3);
            } else if (state2 == 1) {
                ((Graphics2D)g).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)Gray._235, (float)0.0f, (float)size.height, (Color)Gray._200));
                g.fillRect(1, 1, size.width - 3, size.height - 3);
            }
        } else {
            Color bg = UIUtil.getPanelBackground();
            boolean dark = UIUtil.isUnderDarcula();
            g.setColor(state2 == -1 ? ColorUtil.shift((Color)bg, (double)(dark ? 1.4285714285714286 : 0.7)) : (dark ? Gray._255.withAlpha(40) : ALPHA_40));
            g.fillRect(1, 1, size.width - 2, size.height - 2);
        }
    }

    @Override
    public void paintBorder(Graphics g, JComponent component, int state2) {
        if (state2 != 0) {
            this.paintBorder(g, component.getSize(), state2);
        }
    }

    protected void paintBorder(Graphics g, Dimension size, int state2) {
        if (UIUtil.isUnderAquaLookAndFeel()) {
            if (state2 == 1) {
                g.setColor(ALPHA_30);
                g.drawRoundRect(0, 0, size.width - 2, size.height - 2, 4, 4);
            }
        } else {
            double shift = UIUtil.isUnderDarcula() ? 2.0408163265306123 : 0.49;
            g.setColor(ColorUtil.shift((Color)UIUtil.getPanelBackground(), (double)shift));
            ((Graphics2D)g).setStroke(BASIC_STROKE);
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            g.drawRoundRect(0, 0, size.width - 2, size.height - 2, 4, 4);
            config.restore();
        }
    }

    @Override
    public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int x = (int)Math.ceil((actionButton.getWidth() - width) / 2);
        int y = (int)Math.ceil((actionButton.getHeight() - height) / 2);
        this.paintIconAt(g, actionButton, icon, x, y);
    }

    @Override
    public void paintIconAt(Graphics g, ActionButtonComponent button, Icon icon, int x, int y) {
        icon.paintIcon(null, g, x, y);
    }
}

