/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class NotificationTestAction
extends AnAction
implements DumbAware {
    public static final String TEST_GROUP_ID = "Test Notification";

    public NotificationTestAction() {
        super("Add Test Notification");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/notification/impl/actions/NotificationTestAction", "actionPerformed"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        final MessageBus messageBus = project == null ? ApplicationManager.getApplication().getMessageBus() : project.getMessageBus();
        long l = System.currentTimeMillis();
        NotificationType type = l % 3L == 0L ? NotificationType.ERROR : (l % 5L == 0L ? NotificationType.WARNING : NotificationType.INFORMATION);
        NotificationListener listener = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification n, @NotNull HyperlinkEvent e) {
                if (n == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "com/intellij/notification/impl/actions/NotificationTestAction$1", "hyperlinkUpdate"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/notification/impl/actions/NotificationTestAction$1", "hyperlinkUpdate"));
                }
                n.expire();
            }
        };
        String message = "You can<br> close this very<p> very very very long notification by clicking <a href=\"close\">this link</a>. Long long long long. It should be long. Very long. Too long. And even longer.";
        final Notification notification = new Notification(TEST_GROUP_ID, "This is a test notification", "You can<br> close this very<p> very very very long notification by clicking <a href=\"close\">this link</a>. Long long long long. It should be long. Very long. Too long. And even longer.", type, listener);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ((Notifications)messageBus.syncPublisher(Notifications.TOPIC)).notify(notification);
            }
        });
    }
}

