/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NotificationConfiguration", storages={@Storage(file="$APP_CONFIG$/notifications.xml")})
public class NotificationsConfigurationImpl
extends NotificationsConfiguration
implements ExportableApplicationComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.impl.NotificationsConfiguration");
    private static final String SHOW_BALLOONS_ATTRIBUTE = "showBalloons";
    private final Map<String, NotificationSettings> myIdToSettingsMap;
    private final Map<String, String> myToolWindowCapable;
    private final MessageBus myMessageBus;
    public boolean SHOW_BALLOONS;

    public static NotificationsConfigurationImpl getNotificationsConfigurationImpl() {
        return (NotificationsConfigurationImpl)NotificationsConfigurationImpl.getNotificationsConfiguration();
    }

    public NotificationsConfigurationImpl(@NotNull MessageBus bus) {
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/notification/impl/NotificationsConfigurationImpl", "<init>"));
        }
        this.myIdToSettingsMap = new LinkedHashMap<String, NotificationSettings>();
        this.myToolWindowCapable = new LinkedHashMap<String, String>();
        this.SHOW_BALLOONS = true;
        this.myMessageBus = bus;
    }

    public synchronized void registerToolWindowCapability(@NotNull String groupId, @NotNull String toolWindowId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/impl/NotificationsConfigurationImpl", "registerToolWindowCapability"));
        }
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/notification/impl/NotificationsConfigurationImpl", "registerToolWindowCapability"));
        }
        this.myToolWindowCapable.put(groupId, toolWindowId);
    }

    public synchronized boolean hasToolWindowCapability(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/impl/NotificationsConfigurationImpl", "hasToolWindowCapability"));
        }
        return this.getToolWindowId(groupId) != null || this.myToolWindowCapable.containsKey(groupId);
    }

    @Nullable
    public String getToolWindowId(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getToolWindowId"));
        }
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId);
        return group == null ? null : group.getToolWindowId();
    }

    public static NotificationSettings[] getAllSettings() {
        return NotificationsConfigurationImpl.getNotificationsConfigurationImpl()._getAllSettings();
    }

    @Deprecated
    public static void remove(NotificationSettings[] toRemove) {
        NotificationsConfigurationImpl.getNotificationsConfigurationImpl()._remove((String[])ContainerUtil.map2Array((Object[])toRemove, String.class, (Function)new Function<NotificationSettings, String>(){

            public String fun(NotificationSettings notificationSettings) {
                return notificationSettings.getGroupId();
            }
        }));
    }

    public static void remove(String ... toRemove) {
        NotificationsConfigurationImpl.getNotificationsConfigurationImpl()._remove(toRemove);
    }

    private synchronized void _remove(String ... toRemove) {
        for (String id : toRemove) {
            this.myIdToSettingsMap.remove(id);
            this.myToolWindowCapable.remove(id);
        }
    }

    private synchronized NotificationSettings[] _getAllSettings() {
        HashSet settings = ContainerUtil.newHashSet(this.myIdToSettingsMap.values());
        for (NotificationGroup group : NotificationGroup.getAllRegisteredGroups()) {
            settings.add(NotificationsConfigurationImpl.getSettings(group.getDisplayId()));
        }
        NotificationSettings[] result = settings.toArray(new NotificationSettings[settings.size()]);
        Arrays.sort(result, new Comparator<NotificationSettings>(){

            @Override
            public int compare(NotificationSettings o1, NotificationSettings o2) {
                return o1.getGroupId().compareToIgnoreCase(o2.getGroupId());
            }
        });
        return result;
    }

    @Nullable
    private synchronized NotificationSettings _getSettings(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/impl/NotificationsConfigurationImpl", "_getSettings"));
        }
        return this.myIdToSettingsMap.get(groupId);
    }

    @NotNull
    public static NotificationSettings getSettings(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getSettings"));
        }
        NotificationSettings settings = NotificationsConfigurationImpl.getNotificationsConfigurationImpl()._getSettings(groupId);
        NotificationSettings notificationSettings = settings == null ? NotificationsConfigurationImpl.getDefaultSettings(groupId) : settings;
        if (notificationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getSettings"));
        }
        return notificationSettings;
    }

    @NotNull
    private static NotificationSettings getDefaultSettings(String groupId) {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId);
        if (group != null) {
            NotificationSettings notificationSettings = new NotificationSettings(groupId, group.getDisplayType(), group.isLogByDefault(), false);
            if (notificationSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getDefaultSettings"));
            }
            return notificationSettings;
        }
        NotificationSettings notificationSettings = new NotificationSettings(groupId, NotificationDisplayType.BALLOON, true, false);
        if (notificationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getDefaultSettings"));
        }
        return notificationSettings;
    }

    @NotNull
    public String getComponentName() {
        if ("NotificationsConfiguration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getComponentName"));
        }
        return "NotificationsConfiguration";
    }

    public void initComponent() {
        this.myMessageBus.connect().subscribe(TOPIC, (Object)this);
    }

    public synchronized void disposeComponent() {
        this.myIdToSettingsMap.clear();
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType) {
        if (groupDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayName", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        if (displayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayType", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        this.register(groupDisplayName, displayType, true);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog) {
        if (groupDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayName", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        if (displayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayType", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        this.register(groupDisplayName, displayType, shouldLog, false);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        if (groupDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayName", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        if (displayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayType", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        if (!this.isRegistered(groupDisplayName)) {
            new NotificationGroup(groupDisplayName, displayType, shouldLog);
            this.changeSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud);
        } else if (displayType == NotificationDisplayType.TOOL_WINDOW && !this.hasToolWindowCapability(groupDisplayName)) {
            this.changeSettings(NotificationsConfigurationImpl.getSettings(groupDisplayName).withDisplayType(NotificationDisplayType.TOOL_WINDOW));
            this.myToolWindowCapable.put(groupDisplayName, null);
        }
    }

    public void changeSettings(String groupDisplayName, NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        this.changeSettings(new NotificationSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud));
    }

    public synchronized void changeSettings(NotificationSettings settings) {
        String groupDisplayName = settings.getGroupId();
        if (settings.equals(NotificationsConfigurationImpl.getDefaultSettings(groupDisplayName))) {
            this.myIdToSettingsMap.remove(groupDisplayName);
        } else {
            this.myIdToSettingsMap.put(groupDisplayName, settings);
        }
    }

    public synchronized boolean isRegistered(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/notification/impl/NotificationsConfigurationImpl", "isRegistered"));
        }
        return this.myIdToSettingsMap.containsKey(id) || NotificationGroup.findRegisteredGroup((String)id) != null;
    }

    public synchronized Element getState() {
        Element element = new Element("NotificationsConfiguration");
        for (NotificationSettings settings : this.myIdToSettingsMap.values()) {
            element.addContent(settings.save());
        }
        for (String entry : this.myToolWindowCapable.keySet()) {
            element.addContent(new Element("toolWindow").setAttribute("group", entry));
        }
        for (NotificationGroup group : NotificationGroup.getAllRegisteredGroups()) {
            String displayId = group.getDisplayId();
            if (this.myToolWindowCapable.containsKey(displayId) || group.getToolWindowId() == null) continue;
            element.addContent(new Element("toolWindow").setAttribute("group", displayId));
        }
        if (!this.SHOW_BALLOONS) {
            element.setAttribute(SHOW_BALLOONS_ATTRIBUTE, "false");
        }
        return element;
    }

    public synchronized void loadState(Element state2) {
        this.myIdToSettingsMap.clear();
        for (Element child : state2.getChildren("notification")) {
            NotificationSettings settings = NotificationSettings.load(child);
            if (settings == null) continue;
            String id = settings.getGroupId();
            LOG.assertTrue(!this.myIdToSettingsMap.containsKey(id), (Object)String.format("Settings for '%s' already loaded!", id));
            this.myIdToSettingsMap.put(id, settings);
        }
        for (Element child : state2.getChildren("toolWindow")) {
            String group = child.getAttributeValue("group");
            if (group == null || this.myToolWindowCapable.containsKey(group)) continue;
            this.myToolWindowCapable.put(group, null);
        }
        this._remove("Log Only");
        if ("false".equals(state2.getAttributeValue(SHOW_BALLOONS_ATTRIBUTE))) {
            this.SHOW_BALLOONS = false;
        }
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"notifications")};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        if ("Notifications" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getPresentableName"));
        }
        return "Notifications";
    }
}

