/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ui.NotificationsConfigurablePanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NotificationsConfigurable
implements Configurable,
SearchableConfigurable,
OptionalConfigurable,
Configurable.NoMargin,
Configurable.NoScroll {
    public static final String DISPLAY_NAME = "Notifications";
    private NotificationsConfigurablePanel myComponent;

    @Nls
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "reference.settings.ide.settings.notifications";
    }

    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new NotificationsConfigurablePanel();
        }
        return this.myComponent;
    }

    public boolean isModified() {
        return this.myComponent != null && this.myComponent.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myComponent.apply();
    }

    public void reset() {
        this.myComponent.reset();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myComponent);
        this.myComponent = null;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public boolean needDisplay() {
        return NotificationsConfigurationImpl.getAllSettings().length > 0;
    }
}

