/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.XmlLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;

public class XmlHighlightingLexer
extends DelegateLexer {
    public XmlHighlightingLexer() {
        super((Lexer)new XmlLexer());
    }

    public IElementType getTokenType() {
        IElementType tokenType = this.getDelegate().getTokenType();
        if (tokenType == null) {
            return tokenType;
        }
        int state2 = this.getState() & 0xF;
        if ((tokenType = XmlHighlightingLexer.fixWrongTokenTypes(tokenType, state2)) != XmlTokenType.XML_COMMENT_CHARACTERS && tokenType != XmlTokenType.XML_COMMENT_END && tokenType != XmlTokenType.XML_COMMENT_START && tokenType != XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            switch (state2) {
                case 11: {
                    tokenType = XmlTokenType.XML_DECL_START;
                }
            }
        }
        return tokenType;
    }

    static IElementType fixWrongTokenTypes(IElementType tokenType, int state2) {
        if (tokenType == XmlTokenType.XML_NAME) {
            if (state2 == 1 || state2 == 4) {
                tokenType = XmlTokenType.XML_TAG_NAME;
            }
        } else if (tokenType == XmlTokenType.XML_WHITE_SPACE) {
            switch (state2) {
                case 6: 
                case 7: {
                    tokenType = XmlTokenType.TAG_WHITE_SPACE;
                    break;
                }
                default: {
                    tokenType = XmlTokenType.XML_REAL_WHITE_SPACE;
                    break;
                }
            }
        } else if ((tokenType == XmlTokenType.XML_CHAR_ENTITY_REF || tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN) && state2 == 5) {
            return XmlTokenType.XML_COMMENT_CHARACTERS;
        }
        return tokenType;
    }
}

