/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lang.HtmlInlineScriptTokenTypesProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageHtmlInlineScriptTokenTypesProvider;
import com.intellij.lang.LanguageUtil;
import com.intellij.lexer.BaseHtmlLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.HtmlEmbeddedTokenTypesProvider;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.lexer._HtmlLexer;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class HtmlLexer
extends BaseHtmlLexer {
    private static IElementType ourStyleElementType;
    private static IElementType ourInlineStyleElementType;
    private static IElementType ourInlineScriptElementType;
    private IElementType myTokenType;
    private int myTokenStart;
    private int myTokenEnd;

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/lexer/HtmlLexer", "start"));
        }
        this.myTokenType = null;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    @Override
    public void advance() {
        this.myTokenType = null;
        super.advance();
    }

    public IElementType getTokenType() {
        if (this.myTokenType != null) {
            return this.myTokenType;
        }
        IElementType tokenType = super.getTokenType();
        this.myTokenStart = super.getTokenStart();
        this.myTokenEnd = super.getTokenEnd();
        if (this.hasSeenStyle()) {
            if (this.hasSeenTag() && ourStyleElementType != null && HtmlLexer.isStartOfEmbeddmentTagContent(tokenType)) {
                this.myTokenEnd = this.skipToTheEndOfTheEmbeddment();
                tokenType = ourStyleElementType;
            } else if (ourInlineStyleElementType != null && HtmlLexer.isStartOfEmbeddmentAttributeValue(tokenType) && this.hasSeenAttribute()) {
                tokenType = ourInlineStyleElementType;
            }
        } else if (this.hasSeenScript()) {
            boolean canInject;
            Language scriptLanguage = this.getScriptLanguage();
            boolean bl = canInject = scriptLanguage == null || LanguageUtil.isInjectableLanguage((Language)scriptLanguage);
            if (this.hasSeenTag() && HtmlLexer.isStartOfEmbeddmentTagContent(tokenType) && canInject) {
                this.myTokenEnd = this.skipToTheEndOfTheEmbeddment();
                IElementType currentScriptElementType = this.getCurrentScriptElementType();
                tokenType = currentScriptElementType == null ? XmlTokenType.XML_DATA_CHARACTERS : currentScriptElementType;
            } else if (this.hasSeenAttribute() && HtmlLexer.isStartOfEmbeddmentAttributeValue(tokenType) && ourInlineScriptElementType != null) {
                this.myTokenEnd = this.skipToTheEndOfTheEmbeddment();
                tokenType = ourInlineScriptElementType;
            }
        }
        this.myTokenType = tokenType;
        return this.myTokenType;
    }

    private static boolean isStartOfEmbeddmentAttributeValue(IElementType tokenType) {
        return tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
    }

    private static boolean isStartOfEmbeddmentTagContent(IElementType tokenType) {
        return tokenType == XmlTokenType.XML_DATA_CHARACTERS || tokenType == XmlTokenType.XML_CDATA_START || tokenType == XmlTokenType.XML_COMMENT_START || tokenType == XmlTokenType.XML_REAL_WHITE_SPACE || tokenType == TokenType.WHITE_SPACE;
    }

    public HtmlLexer() {
        this((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _HtmlLexer()), TOKENS_TO_MERGE), true);
    }

    protected HtmlLexer(Lexer _baseLexer, boolean _caseInsensitive) {
        super(_baseLexer, _caseInsensitive);
    }

    @Override
    protected boolean isHtmlTagState(int state2) {
        return state2 == 6 || state2 == 8;
    }

    public int getTokenStart() {
        if (this.myTokenType != null) {
            return this.myTokenStart;
        }
        return super.getTokenStart();
    }

    public int getTokenEnd() {
        if (this.myTokenType != null) {
            return this.myTokenEnd;
        }
        return super.getTokenEnd();
    }

    static {
        HtmlEmbeddedTokenTypesProvider[] extensions;
        for (HtmlEmbeddedTokenTypesProvider extension : extensions = (HtmlEmbeddedTokenTypesProvider[])Extensions.getExtensions(HtmlEmbeddedTokenTypesProvider.EXTENSION_POINT_NAME)) {
            if (!"style".equals(extension.getName())) continue;
            ourStyleElementType = extension.getElementType();
            ourInlineStyleElementType = extension.getInlineElementType();
        }
        HtmlInlineScriptTokenTypesProvider provider = LanguageHtmlInlineScriptTokenTypesProvider.getInlineScriptProvider(ourDefaultLanguage);
        ourInlineScriptElementType = provider != null ? provider.getElementType() : null;
    }
}

