/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonBlock;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonFormattingBuilderModel
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        JsonBlock block = new JsonBlock(null, element.getNode(), settings, null, Indent.getNoneIndent(), null);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)element.getContainingFile(), (Block)block, (CodeStyleSettings)settings);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonFormattingBuilderModel", "createModel"));
        }
        return formattingModel;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return null;
    }

    static SpacingBuilder createSpacingBuilder(CodeStyleSettings settings) {
        JsonCodeStyleSettings jsonSettings = (JsonCodeStyleSettings)settings.getCustomSettings(JsonCodeStyleSettings.class);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JsonLanguage.INSTANCE);
        int spacesBeforeComma = commonSettings.SPACE_BEFORE_COMMA ? 1 : 0;
        int spacesBeforeColon = jsonSettings.SPACE_BEFORE_COLON ? 1 : 0;
        int spacesAfterColon = jsonSettings.SPACE_AFTER_COLON ? 1 : 0;
        return new SpacingBuilder(settings, (Language)JsonLanguage.INSTANCE).before(JsonElementTypes.COLON).spacing(spacesBeforeColon, spacesBeforeColon, 0, false, 0).after(JsonElementTypes.COLON).spacing(spacesAfterColon, spacesAfterColon, 0, false, 0).withinPair(JsonElementTypes.L_BRACKET, JsonElementTypes.R_BRACKET).spaceIf(commonSettings.SPACE_WITHIN_BRACKETS).withinPair(JsonElementTypes.L_CURLY, JsonElementTypes.R_CURLY).spaceIf(commonSettings.SPACE_WITHIN_BRACES).before(JsonElementTypes.COMMA).spacing(spacesBeforeComma, spacesBeforeComma, 0, false, 0).after(JsonElementTypes.COMMA).spaceIf(commonSettings.SPACE_AFTER_COMMA);
    }
}

