/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor.folding;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/editor/folding/JsonFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/json/editor/folding/JsonFoldingBuilder", "buildFoldRegions"));
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        JsonFoldingBuilder.collectDescriptorsRecursively(node, document, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/editor/folding/JsonFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    private static void collectDescriptorsRecursively(@NotNull ASTNode node, @NotNull Document document, @NotNull List<FoldingDescriptor> descriptors) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/editor/folding/JsonFoldingBuilder", "collectDescriptorsRecursively"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/json/editor/folding/JsonFoldingBuilder", "collectDescriptorsRecursively"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/json/editor/folding/JsonFoldingBuilder", "collectDescriptorsRecursively"));
        }
        IElementType type = node.getElementType();
        if ((type == JsonElementTypes.OBJECT || type == JsonElementTypes.ARRAY) && JsonFoldingBuilder.spanMultipleLines(node, document)) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        } else if (type == JsonElementTypes.BLOCK_COMMENT) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        } else if (type == JsonElementTypes.LINE_COMMENT) {
            Couple<PsiElement> commentRange = JsonFoldingBuilder.expandLineCommentsRange(node.getPsi());
            int startOffset = ((PsiElement)commentRange.getFirst()).getTextRange().getStartOffset();
            int endOffset = ((PsiElement)commentRange.getSecond()).getTextRange().getEndOffset();
            if (document.getLineNumber(startOffset) != document.getLineNumber(endOffset)) {
                descriptors.add(new FoldingDescriptor(node, new TextRange(startOffset, endOffset)));
            }
        }
        for (ASTNode child : node.getChildren(null)) {
            JsonFoldingBuilder.collectDescriptorsRecursively(child, document, descriptors);
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/editor/folding/JsonFoldingBuilder", "getPlaceholderText"));
        }
        IElementType type = node.getElementType();
        if (type == JsonElementTypes.OBJECT) {
            JsonObject object = (JsonObject)node.getPsi(JsonObject.class);
            List<JsonProperty> properties = object.getPropertyList();
            JsonProperty candidate = null;
            for (JsonProperty property : properties) {
                String name = property.getName();
                JsonValue value = property.getValue();
                if (!(value instanceof JsonLiteral)) continue;
                if ("id".equals(name) || "name".equals(name)) {
                    candidate = property;
                    break;
                }
                if (candidate != null) continue;
                candidate = property;
            }
            if (candidate != null) {
                return "{\"" + candidate.getName() + "\": " + candidate.getValue().getText() + "...}";
            }
            return "{...}";
        }
        if (type == JsonElementTypes.ARRAY) {
            return "[...]";
        }
        if (type == JsonElementTypes.LINE_COMMENT) {
            return "//...";
        }
        if (type == JsonElementTypes.BLOCK_COMMENT) {
            return "/*...*/";
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/editor/folding/JsonFoldingBuilder", "isCollapsedByDefault"));
        }
        return false;
    }

    @NotNull
    public static Couple<PsiElement> expandLineCommentsRange(@NotNull PsiElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/json/editor/folding/JsonFoldingBuilder", "expandLineCommentsRange"));
        }
        Couple couple = Couple.of((Object)JsonPsiUtil.findFurthestSiblingOfSameType(anchor, false), (Object)JsonPsiUtil.findFurthestSiblingOfSameType(anchor, true));
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/editor/folding/JsonFoldingBuilder", "expandLineCommentsRange"));
        }
        return couple;
    }

    private static boolean spanMultipleLines(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/editor/folding/JsonFoldingBuilder", "spanMultipleLines"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/json/editor/folding/JsonFoldingBuilder", "spanMultipleLines"));
        }
        TextRange range = node.getTextRange();
        return document.getLineNumber(range.getStartOffset()) < document.getLineNumber(range.getEndOffset());
    }
}

