/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.beans;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;

public class GroupDescriptor
implements Comparable<GroupDescriptor> {
    public static final double DEFAULT_PRIORITY = 0.0;
    public static final double HIGHER_PRIORITY = 100.0;
    public static final double LOWER_PRIORITY = -100.0;
    public static final int MAX_ID_LENGTH = 30;
    private final String myId;
    private double myPriority;

    public static GroupDescriptor create(String id) {
        return new GroupDescriptor(id);
    }

    public static GroupDescriptor create(String id, double priority) {
        assert (id != null);
        return new GroupDescriptor(id, priority);
    }

    private GroupDescriptor(String id) {
        this(id, 0.0);
    }

    private GroupDescriptor(String id, double priority) {
        assert (id != null);
        this.myId = ConvertUsagesUtil.ensureProperKey(id);
        this.myPriority = priority;
    }

    public String getId() {
        return this.myId;
    }

    public double getPriority() {
        return this.myPriority;
    }

    public void setPriority(double priority) {
        this.myPriority = priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupDescriptor)) {
            return false;
        }
        GroupDescriptor that = (GroupDescriptor)o;
        return !(this.myId != null ? !this.myId.equals(that.myId) : that.myId != null);
    }

    public int hashCode() {
        return this.myId != null ? this.myId.hashCode() : 0;
    }

    @Override
    public int compareTo(GroupDescriptor gd) {
        int priority = (int)(this.getPriority() - gd.getPriority());
        return priority == 0 ? gd.getId().compareTo(gd.getId()) : priority;
    }
}

