/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OsVersionUsageCollector
extends UsagesCollector {
    OsVersionUsageCollector() {
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@Nullable Project project) throws CollectUsagesException {
        UsageDescriptor descriptor = null;
        if (SystemInfo.isUnix && !SystemInfo.isMac) {
            String releaseName = SystemInfo.getUnixReleaseName();
            String releaseVersion = SystemInfo.getUnixReleaseVersion();
            if (releaseName != null && releaseVersion != null) {
                descriptor = new UsageDescriptor(SystemInfo.OS_NAME + " " + releaseName + " " + releaseVersion, 1);
            }
        }
        if (descriptor == null) {
            descriptor = new UsageDescriptor(SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION, 1);
        }
        Set<Object> set = Collections.singleton(descriptor);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/OsVersionUsageCollector", "getUsages"));
        }
        return set;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("user.os.version");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/OsVersionUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

