/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.persistence.ApplicationStatisticsPersistence;
import com.intellij.internal.statistic.persistence.ApplicationStatisticsPersistenceComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ObjectIntHashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntProcedure;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractApplicationUsagesCollector
extends UsagesCollector {
    private static final Logger LOG = Logger.getInstance(AbstractApplicationUsagesCollector.class);

    public void persistProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        try {
            this.persistProjectUsages(project, this.getProjectUsages(project));
        }
        catch (CollectUsagesException e) {
            LOG.info((Throwable)e);
        }
    }

    public void persistProjectUsages(@NotNull Project project, @NotNull Set<UsageDescriptor> usages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        this.persistProjectUsages(project, usages, ApplicationStatisticsPersistenceComponent.getInstance());
    }

    public void persistProjectUsages(@NotNull Project project, @NotNull Set<UsageDescriptor> usages, @NotNull ApplicationStatisticsPersistence persistence) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        if (persistence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistence", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        persistence.persistUsages(this.getGroupId(), project, usages);
    }

    @NotNull
    public Set<UsageDescriptor> getApplicationUsages() {
        Set<UsageDescriptor> set = this.getApplicationUsages(ApplicationStatisticsPersistenceComponent.getInstance());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
        }
        return set;
    }

    @NotNull
    public Set<UsageDescriptor> getApplicationUsages(@NotNull ApplicationStatisticsPersistence persistence) {
        if (persistence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistence", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
        }
        ObjectIntHashMap result = new ObjectIntHashMap();
        for (Set<UsageDescriptor> usageDescriptors : persistence.getApplicationData(this.getGroupId()).values()) {
            if (usageDescriptors.isEmpty()) continue;
            result.ensureCapacity(usageDescriptors.size());
            for (UsageDescriptor usageDescriptor : usageDescriptors) {
                String key = usageDescriptor.getKey();
                result.put((Object)key, result.get((Object)key, 0) + 1);
            }
        }
        if (result.isEmpty()) {
            Set<UsageDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
            }
            return set;
        }
        final THashSet descriptors = new THashSet(result.size());
        result.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String key, int value) {
                descriptors.add((Object)new UsageDescriptor(key, value));
                return true;
            }
        });
        THashSet tHashSet = descriptors;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@Nullable Project project) throws CollectUsagesException {
        if (project != null) {
            this.persistProjectUsages(project, this.getProjectUsages(project));
        }
        Set<UsageDescriptor> set = this.getApplicationUsages();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getUsages"));
        }
        return set;
    }

    @NotNull
    public abstract Set<UsageDescriptor> getProjectUsages(@NotNull Project var1) throws CollectUsagesException;
}

