/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DumpLookupElementWeights
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.DumpLookupElementWeights");

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        DumpLookupElementWeights.dumpLookupElementWeights((LookupImpl)LookupManager.getActiveLookup(editor));
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        presentation.setEnabled(editor != null && LookupManager.getActiveLookup(editor) != null);
    }

    public static void dumpLookupElementWeights(LookupImpl lookup) {
        LookupElement selected = lookup.getCurrentItem();
        String sb = "selected: " + selected;
        if (selected != null) {
            sb = sb + "\nprefix: " + lookup.itemPattern(selected);
        }
        sb = sb + "\nweights:\n" + StringUtil.join(DumpLookupElementWeights.getLookupElementWeights(lookup), (String)"\n");
        System.out.println(sb);
        LOG.info(sb);
    }

    public static List<String> getLookupElementWeights(LookupImpl lookup) {
        Map<LookupElement, StringBuilder> strings = lookup.getRelevanceStrings();
        ArrayList<String> sb = new ArrayList<String>();
        for (LookupElement item : lookup.getItems()) {
            String weight = strings.get(item).toString();
            String s = item.getLookupString() + "\t" + weight;
            sb.add(s);
        }
        return sb;
    }
}

