/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.CommonBundle;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class SocketLock {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.SocketLock");
    public static final int SOCKET_NUMBER_START = 6942;
    public static final int SOCKET_NUMBER_END = 6992;
    private static final int[] FORBIDDEN_PORTS = new int[]{6953, 6969, 6970};
    private ServerSocket mySocket;
    private final List<String> myLockedPaths = new ArrayList<String>();
    private boolean myIsDialogShown = false;
    @NonNls
    private static final String LOCK_THREAD_NAME = "Lock thread";
    @NonNls
    private static final String ACTIVATE_COMMAND = "activate ";
    @Nullable
    private Consumer<List<String>> myActivateListener;
    private volatile int acquiredPort = -1;

    public void setActivateListener(@Nullable Consumer<List<String>> consumer) {
        this.myActivateListener = consumer;
    }

    public synchronized void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: destroyProcess()");
        }
        try {
            this.mySocket.close();
            this.mySocket = null;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    public synchronized int getAcquiredPort() {
        return this.acquiredPort;
    }

    public synchronized ActivateStatus lock(String path, boolean markPort, String ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: lock(path='" + path + "')");
        }
        ActivateStatus status = ActivateStatus.NO_INSTANCE;
        int port = this.acquireSocket();
        if (this.mySocket == null) {
            if (!this.myIsDialogShown) {
                String productName = ApplicationNamesInfo.getInstance().getProductName();
                if (Main.isHeadless()) {
                    throw new RuntimeException("Only one instance of " + productName + " can be run at a time.");
                }
                String pathToLogFile = PathManager.getLogPath() + "/idea.log file".replace('/', File.separatorChar);
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), CommonBundle.message((String)"cannot.start.other.instance.is.running.error.message", (Object[])new Object[]{productName, pathToLogFile}), CommonBundle.message((String)"title.warning", (Object[])new Object[0]), 2);
                this.myIsDialogShown = true;
            }
            return status;
        }
        if (markPort && port != -1) {
            File portMarker = new File(path, "port");
            try {
                FileUtil.writeToFile((File)portMarker, (byte[])Integer.toString(port).getBytes());
            }
            catch (IOException ignored) {
                FileUtil.asyncDelete((File)portMarker);
            }
        }
        for (int i = 6942; i < 6992; ++i) {
            if (SocketLock.isPortForbidden(i) || i == this.mySocket.getLocalPort() || (status = SocketLock.tryActivate(i, path, args)) == ActivateStatus.NO_INSTANCE) continue;
            return status;
        }
        this.myLockedPaths.add(path);
        return status;
    }

    public static boolean isPortForbidden(int port) {
        for (int forbiddenPort : FORBIDDEN_PORTS) {
            if (port != forbiddenPort) continue;
            return true;
        }
        return false;
    }

    private static ActivateStatus tryActivate(int portNumber, String path, String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ServerSocket serverSocket = new ServerSocket(portNumber, 50, NetUtils.getLoopbackAddress());
            serverSocket.close();
            return ActivateStatus.NO_INSTANCE;
        }
        catch (IOException ignored) {
            try {
                Socket socket = new Socket(NetUtils.getLoopbackAddress(), portNumber);
                socket.setSoTimeout(300);
                DataInputStream in = new DataInputStream(socket.getInputStream());
                try {
                    while (true) {
                        result.add(in.readUTF());
                    }
                }
                catch (IOException ignored2) {
                    if (result.contains(path)) {
                        try {
                            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                            out.writeUTF(ACTIVATE_COMMAND + new File(".").getAbsolutePath() + "\u0000" + StringUtil.join((String[])args, (String)"\u0000"));
                            out.flush();
                            String response = in.readUTF();
                            if (response.equals("ok")) {
                                return ActivateStatus.ACTIVATED;
                            }
                        }
                        catch (IOException ignored3) {
                            // empty catch block
                        }
                        return ActivateStatus.CANNOT_ACTIVATE;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
            return ActivateStatus.NO_INSTANCE;
        }
    }

    private int acquireSocket() {
        if (this.mySocket != null) {
            return -1;
        }
        int port = -1;
        for (int i = 6942; i < 6992; ++i) {
            try {
                if (SocketLock.isPortForbidden(i)) continue;
                this.mySocket = new ServerSocket(i, 50, InetAddress.getByName("127.0.0.1"));
                this.acquiredPort = port = i;
                break;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        Thread thread = new Thread((Runnable)new MyRunnable(), LOCK_THREAD_NAME);
        thread.setPriority(1);
        thread.start();
        return port;
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        while (true) {
                            Socket socket = SocketLock.this.mySocket.accept();
                            socket.setSoTimeout(800);
                            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                            SocketLock socketLock = SocketLock.this;
                            synchronized (socketLock) {
                                for (String path : SocketLock.this.myLockedPaths) {
                                    out.writeUTF(path);
                                }
                            }
                            DataInputStream stream = new DataInputStream(socket.getInputStream());
                            String command = stream.readUTF();
                            if (command.startsWith(SocketLock.ACTIVATE_COMMAND)) {
                                List args = StringUtil.split((String)command.substring(SocketLock.ACTIVATE_COMMAND.length()), (String)"\u0000");
                                if (SocketLock.this.myActivateListener != null) {
                                    SocketLock.this.myActivateListener.consume((Object)args);
                                }
                                out.writeUTF("ok");
                            }
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    public static enum ActivateStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

