/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarculaButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int offset;
        Graphics2D g2d = (Graphics2D)g;
        Insets ins = this.getBorderInsets(c);
        int yOff = (ins.top + ins.bottom) / 4;
        boolean square = DarculaButtonUI.isSquare(c);
        int n = offset = square ? 1 : this.getOffset();
        if (c.hasFocus()) {
            DarculaUIUtil.paintFocusRing(g2d, offset, yOff, width - 2 * offset, height - 2 * yOff);
        } else {
            GraphicsConfig config = new GraphicsConfig(g);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g2d.setPaint(UIUtil.getGradientPaint((float)(width / 2), (float)(y + yOff + 1), (Color)Gray._80.withAlpha(90), (float)(width / 2), (float)(height - 2 * yOff), (Color)Gray._90.withAlpha(90)));
            ((Graphics2D)g).setPaint(Gray._100.withAlpha(180));
            g.drawRoundRect(x + offset, y + yOff, width - 2 * offset, height - 2 * yOff, square ? 3 : 5, square ? 3 : 5);
            config.restore();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarculaButtonUI.isSquare(c)) {
            return new InsetsUIResource(2, 0, 2, 0);
        }
        return new InsetsUIResource(8, 16, 8, 14);
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

