/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.configurable.TodoTypeListCellRenderer;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoPattern;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PatternDialog
extends DialogWrapper {
    private final TodoPattern myPattern;
    private final JComboBox myIconComboBox;
    private final JCheckBox myCaseSensitiveCheckBox;
    private final JTextField myPatternStringField;
    private final ColorAndFontDescriptionPanel myColorAndFontDescriptionPanel;
    private final ColorAndFontDescription myColorAndFontDescription;
    private final JCheckBox myUsedDefaultColorsCeckBox;

    public PatternDialog(Component parent, TodoPattern pattern) {
        super(parent, true);
        TodoAttributes attrs = pattern.getAttributes();
        this.myPattern = pattern;
        this.myIconComboBox = new JComboBox<Icon>(new Icon[]{AllIcons.General.TodoDefault, AllIcons.General.TodoQuestion, AllIcons.General.TodoImportant});
        this.myIconComboBox.setSelectedItem(attrs.getIcon());
        this.myIconComboBox.setRenderer(new TodoTypeListCellRenderer());
        this.myCaseSensitiveCheckBox = new JCheckBox(IdeBundle.message((String)"checkbox.case.sensitive", (Object[])new Object[0]), pattern.isCaseSensitive());
        this.myPatternStringField = new JTextField(pattern.getPatternString());
        this.myUsedDefaultColorsCeckBox = new JCheckBox(IdeBundle.message((String)"checkbox.todo.use.default.colors", (Object[])new Object[0]));
        this.myUsedDefaultColorsCeckBox.setSelected(!attrs.shouldUseCustomTodoColor());
        this.myColorAndFontDescriptionPanel = new ColorAndFontDescriptionPanel();
        TextAttributes attributes = this.myPattern.getAttributes().getCustomizedTextAttributes();
        this.myColorAndFontDescription = new TextAttributesDescription(null, null, attributes, null, EditorColorsManager.getInstance().getGlobalScheme(), null, null){

            @Override
            public void apply(EditorColorsScheme scheme) {
            }

            @Override
            public boolean isErrorStripeEnabled() {
                return true;
            }
        };
        this.myColorAndFontDescriptionPanel.reset(this.myColorAndFontDescription);
        this.updateCustomColorsPanel();
        this.myUsedDefaultColorsCeckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternDialog.this.updateCustomColorsPanel();
            }
        });
        this.init();
    }

    private void updateCustomColorsPanel() {
        boolean useCustomColors = this.useCustomTodoColor();
        if (useCustomColors) {
            this.myColorAndFontDescriptionPanel.reset(this.myColorAndFontDescription);
        } else {
            this.myColorAndFontDescriptionPanel.resetDefault();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPatternStringField;
    }

    protected void doOKAction() {
        this.myPattern.setPatternString(this.myPatternStringField.getText().trim());
        this.myPattern.setCaseSensitive(this.myCaseSensitiveCheckBox.isSelected());
        TodoAttributes attrs = this.myPattern.getAttributes();
        attrs.setIcon((Icon)this.myIconComboBox.getSelectedItem());
        attrs.setUseCustomTodoColor(this.useCustomTodoColor(), TodoAttributesUtil.getDefaultColorSchemeTextAttributes());
        if (this.useCustomTodoColor()) {
            this.myColorAndFontDescriptionPanel.apply(this.myColorAndFontDescription, null);
        }
        super.doOKAction();
    }

    private boolean useCustomTodoColor() {
        return !this.myUsedDefaultColorsCeckBox.isSelected();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 10), 0, 0);
        JLabel patternLabel = new JLabel(IdeBundle.message((String)"label.todo.pattern", (Object[])new Object[0]));
        panel.add((Component)patternLabel, gb);
        Dimension oldPreferredSize = this.myPatternStringField.getPreferredSize();
        this.myPatternStringField.setPreferredSize(new Dimension(300, oldPreferredSize.height));
        gb.gridx = 1;
        gb.gridwidth = 0;
        gb.weightx = 1.0;
        panel.add((Component)this.myPatternStringField, gb);
        JLabel iconLabel = new JLabel(IdeBundle.message((String)"label.todo.icon", (Object[])new Object[0]));
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        panel.add((Component)iconLabel, gb);
        gb.gridx = 1;
        gb.fill = 0;
        gb.gridwidth = 0;
        gb.weightx = 0.0;
        panel.add((Component)this.myIconComboBox, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.fill = 2;
        gb.gridwidth = 0;
        gb.weightx = 1.0;
        panel.add((Component)this.myCaseSensitiveCheckBox, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.fill = 2;
        gb.gridwidth = 0;
        gb.weightx = 1.0;
        panel.add((Component)this.myUsedDefaultColorsCeckBox, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 0;
        gb.weightx = 1.0;
        panel.add((Component)this.myColorAndFontDescriptionPanel, gb);
        return panel;
    }
}

