/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.SingleFileToDoNode;
import com.intellij.ide.todo.nodes.ToDoRootNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;

public final class CurrentFileTodosTreeStructure
extends TodoTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.todo.CurrentFileTodosTreeStructure");
    private static final Object[] ourEmptyArray = new Object[0];
    private PsiFile myFile;

    public CurrentFileTodosTreeStructure(Project project) {
        super(project);
    }

    @Override
    protected void validateCache() {
        super.validateCache();
        if (this.myFile != null && !this.myFile.isValid()) {
            VirtualFile vFile = this.myFile.getVirtualFile();
            this.myFile = vFile.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(vFile) : null;
        }
    }

    PsiFile getFile() {
        return this.myFile;
    }

    public void setFile(PsiFile file) {
        this.myFile = file;
        this.myRootElement = this.createRootElement();
    }

    @Override
    public boolean accept(PsiFile psiFile) {
        if (this.myFile == null || !this.myFile.equals(psiFile) || !this.myFile.isValid()) {
            return false;
        }
        return this.myTodoFilter != null && this.myTodoFilter.accept(this.mySearchHelper, psiFile) || this.myTodoFilter == null && this.mySearchHelper.getTodoItemsCount(psiFile) > 0;
    }

    @Override
    boolean isAutoExpandNode(NodeDescriptor descriptor) {
        Object element = descriptor.getElement();
        if (element == this.myFile) {
            return true;
        }
        return super.isAutoExpandNode(descriptor);
    }

    @Override
    Object getFirstSelectableElement() {
        if (this.myRootElement instanceof SingleFileToDoNode) {
            return ((SingleFileToDoNode)this.myRootElement).getFileNode();
        }
        return null;
    }

    @Override
    public boolean getIsPackagesShown() {
        return this.myArePackagesShown;
    }

    @Override
    protected AbstractTreeNode createRootElement() {
        if (!this.accept(this.myFile)) {
            return new ToDoRootNode(this.myProject, new Object(), this.myBuilder, this.mySummaryElement);
        }
        return new SingleFileToDoNode(this.myProject, this.myFile, this.myBuilder);
    }
}

