/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;

public class TreeActionWrapper
extends ToggleAction
implements DumbAware {
    private final TreeAction myAction;
    private final TreeActionsOwner myStructureView;

    public TreeActionWrapper(@NotNull TreeAction action, @NotNull TreeActionsOwner structureView) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ide/structureView/newStructureView/TreeActionWrapper", "<init>"));
        }
        if (structureView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureView", "com/intellij/ide/structureView/newStructureView/TreeActionWrapper", "<init>"));
        }
        this.myAction = action;
        this.myStructureView = structureView;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        ActionPresentation actionPresentation = this.myAction.getPresentation();
        if (presentation.getClientProperty("HIDE_ICON") == null) {
            presentation.setIcon(actionPresentation.getIcon());
        }
        presentation.setText(actionPresentation.getText());
    }

    public boolean isSelected(AnActionEvent e) {
        return TreeModelWrapper.isActive(this.myAction, this.myStructureView);
    }

    public void setSelected(AnActionEvent e, boolean state2) {
        this.myStructureView.setActionActive(this.myAction.getName(), TreeModelWrapper.shouldRevert(this.myAction) ? !state2 : state2);
    }
}

