/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.scratch.ScratchpadManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewScratchFileAction
extends AnAction
implements DumbAware {
    public static final int MAX_VISIBLE_SIZE = 20;

    public NewScratchFileAction() {
        super("New Scratch File...", null, null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/NewScratchFileAction", "update"));
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && Registry.is((String)"ide.scratch.enabled"));
    }

    public static List<String> getLastUsedLanguagesIds(Project project) {
        Object[] values = PropertiesComponent.getInstance((Project)project).getValues(ScratchpadManager.class.getName());
        return values == null ? ContainerUtil.emptyList() : ContainerUtil.list((Object[])values);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/NewScratchFileAction", "actionPerformed"));
        }
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Language context = file != null ? file.getLanguage() : null;
        ListPopup popup = NewScratchFileAction.buildLanguagePopup(project, context, new Consumer<Language>(){

            public void consume(Language language) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
                VirtualFile file = ScratchpadManager.getInstance(project).createScratchFile(NewScratchFileAction.substitute(project, language));
                FileEditorManager.getInstance((Project)project).openFile(file, true);
            }
        });
        popup.showCenteredInCurrentWindow(project);
    }

    @NotNull
    public static Language substitute(@NotNull Project project, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/NewScratchFileAction", "substitute"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/NewScratchFileAction", "substitute"));
        }
        Language language2 = LanguageSubstitutors.INSTANCE.substituteLanguage(language, (VirtualFile)new LightVirtualFile(), project);
        if (language2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction", "substitute"));
        }
        return language2;
    }

    @NotNull
    static ListPopup buildLanguagePopup(@NotNull Project project, @Nullable Language context, final Consumer<Language> onChoosen) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguagePopup"));
        }
        List languages = LanguageUtil.getFileLanguages();
        final ArrayList ids = ContainerUtil.newArrayList(NewScratchFileAction.getLastUsedLanguagesIds(project));
        if (context != null) {
            ids.add(context.getID());
        }
        if (ids.isEmpty()) {
            ids.add(StdLanguages.TEXT.getID());
        }
        ContainerUtil.sort((List)languages, (Comparator)new Comparator<Language>(){

            @Override
            public int compare(@NotNull Language o1, @NotNull Language o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/scratch/NewScratchFileAction$2", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/scratch/NewScratchFileAction$2", "compare"));
                }
                int ind1 = ids.indexOf(o1.getID());
                int ind2 = ids.indexOf(o2.getID());
                if (ind1 == -1) {
                    ind1 = 666;
                }
                if (ind2 == -1) {
                    ind2 = 666;
                }
                return ind1 - ind2;
            }
        });
        BaseListPopupStep<Language> step = new BaseListPopupStep<Language>("Choose Language", languages){

            @NotNull
            public String getTextFor(Language value) {
                String string = value.getDisplayName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction$3", "getTextFor"));
                }
                return string;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(Language selectedValue, boolean finalChoice) {
                onChoosen.consume((Object)selectedValue);
                return null;
            }

            public Icon getIconFor(Language language) {
                LanguageFileType associatedLanguage = language.getAssociatedFileType();
                return associatedLanguage != null ? associatedLanguage.getIcon() : null;
            }
        };
        step.setDefaultOptionIndex(0);
        ListPopup listPopup = NewScratchFileAction.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguagePopup"));
        }
        return listPopup;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/scratch/NewScratchFileAction", "tweakSizeToPreferred"));
        }
        int nameLen = 0;
        ListPopupStep step = popup.getListStep();
        List values = step.getValues();
        for (Object v : values) {
            nameLen = Math.max(nameLen, step.getTextFor(v).length());
        }
        if (values.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getMinimumSize();
            size.height *= 20;
            popup.setSize(size);
        }
        ListPopup listPopup = popup;
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction", "tweakSizeToPreferred"));
        }
        return listPopup;
    }
}

