/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PluginInstaller {
    private static final Object myLock = new Object();

    private PluginInstaller() {
    }

    public static boolean prepareToInstall(List<PluginNode> pluginsToInstall, List<IdeaPluginDescriptor> allPlugins, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller", "prepareToInstall"));
        }
        THashSet dependant = new THashSet();
        boolean install = PluginInstaller.prepareToInstall(pluginsToInstall, allPlugins, (Set<PluginNode>)dependant, indicator);
        for (PluginNode node : dependant) {
            if (pluginsToInstall.contains(node)) continue;
            pluginsToInstall.add(node);
        }
        return install;
    }

    private static boolean prepareToInstall(List<PluginNode> pluginsToInstall, List<IdeaPluginDescriptor> allPlugins, Set<PluginNode> installedDependant, @NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/ide/plugins/PluginInstaller", "prepareToInstall"));
        }
        SmartList pluginIds = new SmartList();
        for (PluginNode pluginNode : pluginsToInstall) {
            pluginIds.add(pluginNode.getPluginId());
        }
        boolean result = false;
        for (PluginNode pluginNode : pluginsToInstall) {
            progressIndicator.setText(pluginNode.getName());
            try {
                result |= PluginInstaller.prepareToInstall(pluginNode, (List<PluginId>)pluginIds, allPlugins, installedDependant, progressIndicator);
            }
            catch (IOException e) {
                String title = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
                Notifications.Bus.notify((Notification)new Notification(title, title, pluginNode.getName() + ": " + e.getMessage(), NotificationType.ERROR));
                return false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean prepareToInstall(PluginNode pluginNode, List<PluginId> pluginIds, List<IdeaPluginDescriptor> allPlugins, Set<PluginNode> installedDependant, @NotNull ProgressIndicator progressIndicator) throws IOException {
        PluginDownloader downloader;
        block26: {
            String repositoryName;
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/ide/plugins/PluginInstaller", "prepareToInstall"));
            }
            installedDependant.add(pluginNode);
            if (pluginNode.getDepends() != null && pluginNode.getDepends().size() > 0) {
                Object[] optionalDependentPluginIds = pluginNode.getOptionalDependentPluginIds();
                final ArrayList<PluginNode> depends = new ArrayList<PluginNode>();
                final ArrayList<PluginNode> optionalDeps = new ArrayList<PluginNode>();
                for (int i = 0; i < pluginNode.getDepends().size(); ++i) {
                    PluginId depPluginId = pluginNode.getDepends().get(i);
                    if (PluginManager.isPluginInstalled(depPluginId) || PluginManagerCore.isModuleDependency(depPluginId) || PluginManagerUISettings.getInstance().getInstalledPlugins().contains((Object)depPluginId.getIdString()) || pluginIds != null && pluginIds.contains(depPluginId)) continue;
                    PluginNode depPlugin = new PluginNode(depPluginId);
                    depPlugin.setSize("-1");
                    depPlugin.setName(depPluginId.getIdString());
                    if (!PluginInstaller.isPluginInRepo(depPluginId, allPlugins)) continue;
                    if (ArrayUtil.indexOf((Object[])optionalDependentPluginIds, (Object)depPluginId) != -1) {
                        optionalDeps.add(depPlugin);
                        continue;
                    }
                    depends.add(depPlugin);
                }
                if (depends.size() > 0) {
                    final boolean[] proceed = new boolean[1];
                    final StringBuffer buf = new StringBuffer();
                    for (PluginNode depend : depends) {
                        buf.append(depend.getName()).append(",");
                    }
                    try {
                        GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                String title = IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]);
                                String message = IdeBundle.message((String)"plugin.manager.dependencies.detected.message", (Object[])new Object[]{depends.size(), buf.substring(0, buf.length() - 1)});
                                proceed[0] = Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0;
                            }
                        });
                    }
                    catch (Exception e) {
                        return false;
                    }
                    if (proceed[0]) {
                        if (!PluginInstaller.prepareToInstall(depends, allPlugins, installedDependant, progressIndicator)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (optionalDeps.size() > 0) {
                    final StringBuffer buf = new StringBuffer();
                    for (PluginNode depend : optionalDeps) {
                        buf.append(depend.getName()).append(",");
                    }
                    final boolean[] proceed = new boolean[1];
                    try {
                        GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                proceed[0] = Messages.showYesNoDialog((String)IdeBundle.message((String)"plugin.manager.optional.dependencies.detected.message", (Object[])new Object[]{optionalDeps.size(), buf.substring(0, buf.length() - 1)}), (String)IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) == 0;
                            }
                        });
                    }
                    catch (Exception e) {
                        return false;
                    }
                    if (proceed[0] && !PluginInstaller.prepareToInstall(optionalDeps, allPlugins, installedDependant, progressIndicator)) {
                        return false;
                    }
                }
            }
            if ((repositoryName = pluginNode.getRepositoryName()) != null) {
                try {
                    THashMap downloaders = new THashMap();
                    if (!UpdateChecker.checkPluginsHost(repositoryName, (Map<PluginId, PluginDownloader>)downloaders, progressIndicator)) {
                        return false;
                    }
                    downloader = (PluginDownloader)downloaders.get(pluginNode.getPluginId());
                    if (downloader == null) {
                        return false;
                    }
                    break block26;
                }
                catch (Exception e) {
                    return false;
                }
            }
            downloader = PluginDownloader.createDownloader(pluginNode);
        }
        if (downloader.prepareToInstall(progressIndicator)) {
            Object object = myLock;
            synchronized (object) {
                downloader.install();
            }
        } else {
            return false;
        }
        pluginNode.setStatus(5);
        return true;
    }

    private static boolean isPluginInRepo(PluginId depPluginId, List<IdeaPluginDescriptor> allPlugins) {
        for (IdeaPluginDescriptor plugin : allPlugins) {
            if (!plugin.getPluginId().equals(depPluginId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareToUninstall(PluginId pluginId) throws IOException {
        Object object = myLock;
        synchronized (object) {
            if (PluginManager.isPluginInstalled(pluginId)) {
                IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(pluginId);
                if (pluginDescriptor != null) {
                    StartupActionScriptManager.DeleteCommand deleteOld = new StartupActionScriptManager.DeleteCommand(pluginDescriptor.getPath());
                    StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteOld);
                } else {
                    PluginManagerMain.LOG.error("Plugin not found: " + pluginId);
                }
            }
        }
    }
}

