/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.masterKey;

import com.intellij.icons.AllIcons;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PasswordComponentBase {
    protected final MasterKeyPasswordSafe mySafe;
    private final String myTitle;
    private JPanel myRootPanel;
    private JLabel myIconLabel;
    protected JLabel myPromptLabel;
    protected JPanel myPasswordPanel;
    protected JPanel myNewPasswordPanel;
    protected JPasswordField myPasswordField;
    protected JPasswordField myNewPasswordField;
    protected JPasswordField myConfirmPasswordField;
    protected JCheckBox myEncryptCheckBox;
    protected JLabel myPasswordLabel;
    protected JLabel myNewPasswordLabel;

    public PasswordComponentBase(@NotNull MasterKeyPasswordSafe safe, @NotNull String title) {
        if (safe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safe", "com/intellij/ide/passwordSafe/impl/providers/masterKey/PasswordComponentBase", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/passwordSafe/impl/providers/masterKey/PasswordComponentBase", "<init>"));
        }
        this.mySafe = safe;
        this.myTitle = title;
        this.$$$setupUI$$$();
        this.myIconLabel.setText("");
        this.myIconLabel.setIcon(AllIcons.General.PasswordLock);
        this.myIconLabel.setDisabledIcon(AllIcons.General.PasswordLock);
        this.myPromptLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        if (!safe.isOsProtectedPasswordSupported()) {
            this.myEncryptCheckBox.setSelected(false);
            this.myEncryptCheckBox.setVisible(false);
        } else {
            this.myEncryptCheckBox.setSelected(safe.isPasswordEncrypted());
        }
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myPasswordField.isEnabled()) {
            return this.myPasswordField;
        }
        if (this.myNewPasswordField.isEnabled()) {
            return this.myNewPasswordField;
        }
        throw new AssertionError((Object)"no visible fields found");
    }

    public String getTitle() {
        return this.myTitle;
    }

    public ValidationInfo doValidate() {
        if (this.myNewPasswordField.isEnabled() && !Arrays.equals(this.myNewPasswordField.getPassword(), this.myConfirmPasswordField.getPassword())) {
            return new ValidationInfo("New passwords do not match", (JComponent)this.myConfirmPasswordField);
        }
        return null;
    }

    public abstract boolean apply();

    public String getHelpId() {
        return null;
    }

    @Nullable
    protected ValidationInfo validatePassword() {
        String oldPassword;
        if (this.myPasswordField.isEnabled() && !this.mySafe.setMasterPassword(oldPassword = new String(this.myPasswordField.getPassword()))) {
            return new ValidationInfo("Password is incorrect", (JComponent)this.myPasswordField);
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPasswordField jPasswordField;
        JLabel jLabel;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPasswordField jPasswordField2;
        JPasswordField jPasswordField3;
        JLabel jLabel2;
        JPanel jPanel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JPanel jPanel3;
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(15, 10, 0, 20), null, 0, 0, null, null));
        this.myIconLabel = jLabel4 = new JLabel();
        jLabel4.setText("icon");
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 5, 1, 9, 0, 0, 0, null, null, null));
        this.myPromptLabel = jLabel3 = new JLabel();
        jLabel3.setText("Prompt");
        jPanel3.add((Component)jLabel3, new GridConstraints(3, 1, 1, 2, 9, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 3, 2, 0, 3, 0, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 10, 10, 0), null, 0, 0, null, null));
        this.myNewPasswordPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 2, 2, 0, 3, 0, 0, null, null, null, 0, true));
        this.myNewPasswordLabel = jLabel2 = new JLabel();
        jLabel2.setText("New password");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNewPasswordField = jPasswordField3 = new JPasswordField();
        jPanel2.add((Component)jPasswordField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Confirm password");
        jLabel5.setDisplayedMnemonic('C');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfirmPasswordField = jPasswordField2 = new JPasswordField();
        jPanel2.add((Component)jPasswordField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEncryptCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Encrypt with OS user credentials");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jCheckBox.setSelected(true);
        jCheckBox.setToolTipText("The master password will be stored in password database \nencrypted with user credentials using OS-specific mechanisms.\nIf this checkbox is selected, the master password will not be asked\nfrom user, on new session.");
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 4, 0, 3, 0, null, null, null));
        this.myPasswordPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myPasswordLabel = jLabel = new JLabel();
        jLabel.setText("Password");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel2.setLabelFor(jPasswordField3);
        jLabel5.setLabelFor(jPasswordField2);
        jLabel.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

