/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarModel {
    private List<Object> myModel = Collections.emptyList();
    private int mySelectedIndex;
    private final Project myProject;
    private final NavBarModelListener myNotificator;
    private boolean myChanged = true;
    private boolean updated = false;
    private boolean isFixedComponent = false;

    public NavBarModel(Project project) {
        this.myProject = project;
        this.myNotificator = (NavBarModelListener)project.getMessageBus().syncPublisher(NavBarModelListener.NAV_BAR);
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    @Nullable
    public Object getSelectedValue() {
        return this.getElement(this.mySelectedIndex);
    }

    @Nullable
    public Object getElement(int index) {
        if (index != -1 && index < this.myModel.size()) {
            return this.myModel.get(index);
        }
        return null;
    }

    public int size() {
        return this.myModel.size();
    }

    public boolean isEmpty() {
        return this.myModel.isEmpty();
    }

    public int getIndexByModel(int index) {
        if (index < 0) {
            return this.myModel.size() + index;
        }
        if (index >= this.myModel.size() && this.myModel.size() > 0) {
            return index % this.myModel.size();
        }
        return index;
    }

    protected void updateModel(DataContext dataContext) {
        if (LaterInvocator.isInModalContext() || this.updated && !this.isFixedComponent) {
            return;
        }
        if (PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext) instanceof NavBarPanel) {
            return;
        }
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiElement == null) {
            psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        psiElement = NavBarModel.normalize(psiElement);
        if (!this.myModel.isEmpty() && this.myModel.get(this.myModel.size() - 1).equals(psiElement) && !this.myChanged) {
            return;
        }
        if (psiElement != null && psiElement.isValid()) {
            this.updateModel(psiElement);
        } else {
            if (UISettings.getInstance().SHOW_NAVIGATION_BAR && !this.myModel.isEmpty()) {
                return;
            }
            Object root = this.calculateRoot(dataContext);
            if (root != null) {
                this.setModel(Collections.singletonList(root));
            }
        }
        this.setChanged(false);
        this.updated = true;
    }

    private Object calculateRoot(DataContext dataContext) {
        Object root = LangDataKeys.MODULE.getData(dataContext);
        if (root != null) {
            return root;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Object projectGrandChild = null;
        CommonProcessors.FindFirstAndOnlyProcessor processor = new CommonProcessors.FindFirstAndOnlyProcessor();
        this.processChildren(project, (Processor<Object>)processor);
        Object projectChild = processor.reset();
        if (projectChild != null) {
            this.processChildren(projectChild, (Processor<Object>)processor);
            projectGrandChild = processor.reset();
        }
        return ObjectUtils.chooseNotNull(projectGrandChild, (Object)ObjectUtils.chooseNotNull((Object)projectChild, (Object)project));
    }

    protected void updateModel(final PsiElement psiElement) {
        final HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        for (VirtualFile virtualFile : projectRootManager.getContentRoots()) {
            VirtualFile parent = virtualFile.getParent();
            if (parent != null && projectFileIndex.isInContent(parent)) continue;
            roots.add(virtualFile);
        }
        for (NavBarModelExtension navBarModelExtension : (NavBarModelExtension[])Extensions.getExtensions(NavBarModelExtension.EP_NAME)) {
            for (VirtualFile root : navBarModelExtension.additionalRoots(psiElement.getProject())) {
                VirtualFile parent = root.getParent();
                if (parent != null && projectFileIndex.isInContent(parent)) continue;
                roots.add(root);
            }
        }
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                NavBarModel.this.traverseToRoot(psiElement, roots, arrayList);
            }
        });
        this.setModel(arrayList);
    }

    void revalidate() {
        ArrayList<Object> objects = new ArrayList<Object>();
        boolean update = false;
        for (Object o : this.myModel) {
            if (NavBarModel.isValid(o)) {
                objects.add(o);
                continue;
            }
            update = true;
            break;
        }
        if (update) {
            this.setModel(objects);
        }
    }

    protected void setModel(List<Object> model) {
        if (!((Object)model).equals(this.myModel)) {
            this.myModel = model;
            this.myNotificator.modelChanged();
            this.mySelectedIndex = this.myModel.size() - 1;
            this.myNotificator.selectionChanged();
        }
    }

    public void updateModel(Object object) {
        if (object instanceof PsiElement) {
            this.updateModel((PsiElement)object);
        } else if (object instanceof Module) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(this.myProject);
            l.add(object);
            this.setModel(l);
        }
    }

    private void traverseToRoot(@NotNull PsiElement psiElement, Set<VirtualFile> roots, List<Object> model) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ide/navigationToolbar/NavBarModel", "traverseToRoot"));
        }
        if (!psiElement.isValid()) {
            return;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null && containingFile.getVirtualFile() == null) {
            return;
        }
        Object resultElement = psiElement = NavBarModel.getOriginalElement(psiElement);
        if ((resultElement = NavBarModel.normalize(resultElement)) == null) {
            return;
        }
        boolean foundByExtension = false;
        for (NavBarModelExtension modelExtension : (NavBarModelExtension[])Extensions.getExtensions(NavBarModelExtension.EP_NAME)) {
            PsiElement parent = modelExtension.getParent((PsiElement)resultElement);
            if (parent == null) continue;
            if (parent != resultElement) {
                this.traverseToRoot(parent, roots, model);
            }
            foundByExtension = true;
            break;
        }
        if (!foundByExtension) {
            if (containingFile != null) {
                PsiDirectory containingDirectory = containingFile.getContainingDirectory();
                if (containingDirectory != null) {
                    this.traverseToRoot((PsiElement)containingDirectory, roots, model);
                }
            } else if (psiElement instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)psiElement;
                if (!roots.contains(psiDirectory.getVirtualFile())) {
                    PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
                    if (parentDirectory == null) {
                        VirtualFile jar = PathUtil.getLocalFile((VirtualFile)psiDirectory.getVirtualFile());
                        if (ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(jar)) {
                            parentDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(jar.getParent());
                        }
                    }
                    if (parentDirectory != null) {
                        this.traverseToRoot((PsiElement)parentDirectory, roots, model);
                    }
                }
            } else if (psiElement instanceof PsiFileSystemItem) {
                PsiDirectory parentDirectory;
                VirtualFile virtualFile = ((PsiFileSystemItem)psiElement).getVirtualFile();
                if (virtualFile == null) {
                    return;
                }
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                resultElement = virtualFile.isDirectory() ? psiManager.findDirectory(virtualFile) : psiManager.findFile(virtualFile);
                if (resultElement == null) {
                    return;
                }
                VirtualFile parentVFile = virtualFile.getParent();
                if (parentVFile != null && !roots.contains(parentVFile) && (parentDirectory = psiManager.findDirectory(parentVFile)) != null) {
                    this.traverseToRoot((PsiElement)parentDirectory, roots, model);
                }
            }
        }
        model.add(resultElement);
    }

    private static PsiElement getOriginalElement(PsiElement psiElement) {
        PsiElement originalElement = psiElement.getOriginalElement();
        return !(psiElement instanceof PsiCompiledElement) && originalElement instanceof PsiCompiledElement ? psiElement : originalElement;
    }

    protected boolean hasChildren(Object object) {
        return !this.processChildren(object, (Processor<Object>)new CommonProcessors.FindFirstProcessor());
    }

    public void setChanged(boolean changed) {
        this.myChanged = changed;
    }

    static boolean isValid(final Object object) {
        if (object instanceof Project) {
            return !((Project)object).isDisposed();
        }
        if (object instanceof Module) {
            return !((Module)object).isDisposed();
        }
        if (object instanceof PsiElement) {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return ((PsiElement)object).isValid();
                }
            });
        }
        return object != null;
    }

    @Nullable
    private static PsiElement normalize(@Nullable PsiElement child) {
        if (child == null) {
            return null;
        }
        for (NavBarModelExtension modelExtension : (NavBarModelExtension[])Extensions.getExtensions(NavBarModelExtension.EP_NAME)) {
            if ((child = modelExtension.adjustElement(child)) != null) continue;
            return null;
        }
        return child;
    }

    protected List<Object> getChildren(Object object) {
        final ArrayList result = ContainerUtil.newArrayList();
        Processor<Object> processor = new Processor<Object>(){

            public boolean process(Object o) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)(o instanceof PsiElement ? NavBarModel.normalize((PsiElement)o) : o));
                return true;
            }
        };
        this.processChildren(object, processor);
        Collections.sort(result, new SiblingsComparator());
        return result;
    }

    private boolean processChildren(Object object, @NotNull Processor<Object> processor) {
        Object rootElement;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/ide/navigationToolbar/NavBarModel", "processChildren"));
        }
        if (!NavBarModel.isValid(object)) {
            return true;
        }
        Object object2 = rootElement = this.size() > 1 ? this.getElement(1) : null;
        if (rootElement != null && !NavBarModel.isValid(rootElement)) {
            return true;
        }
        for (NavBarModelExtension modelExtension : (NavBarModelExtension[])Extensions.getExtensions(NavBarModelExtension.EP_NAME)) {
            if (!(modelExtension instanceof AbstractNavBarModelExtension) || ((AbstractNavBarModelExtension)modelExtension).processChildren(object, rootElement, processor)) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        return this.myModel.get(index);
    }

    public int indexOf(Object value) {
        return this.myModel.indexOf(value);
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this.mySelectedIndex != selectedIndex) {
            this.mySelectedIndex = selectedIndex;
            this.myNotificator.selectionChanged();
        }
    }

    public void setFixedComponent(boolean fixedComponent) {
        this.isFixedComponent = fixedComponent;
    }

    private static final class SiblingsComparator
    implements Comparator<Object> {
        private SiblingsComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Pair<Integer, String> w1 = SiblingsComparator.getWeightedName(o1);
            Pair<Integer, String> w2 = SiblingsComparator.getWeightedName(o2);
            if (w1 == null) {
                return w2 == null ? 0 : -1;
            }
            if (w2 == null) {
                return 1;
            }
            if (!((Integer)w1.first).equals(w2.first)) {
                return -((Integer)w1.first).intValue() + (Integer)w2.first;
            }
            return Comparing.compare((Object)w1.second, (Object)w2.second, (Comparator)String.CASE_INSENSITIVE_ORDER);
        }

        @Nullable
        private static Pair<Integer, String> getWeightedName(Object object) {
            if (object instanceof Module) {
                return Pair.create((Object)5, (Object)((Module)object).getName());
            }
            if (object instanceof PsiDirectoryContainer) {
                return Pair.create((Object)4, (Object)((PsiDirectoryContainer)object).getName());
            }
            if (object instanceof PsiDirectory) {
                return Pair.create((Object)4, (Object)((PsiDirectory)object).getName());
            }
            if (object instanceof PsiFile) {
                return Pair.create((Object)2, (Object)((PsiFile)object).getName());
            }
            if (object instanceof PsiNamedElement) {
                return Pair.create((Object)3, (Object)((PsiNamedElement)object).getName());
            }
            return null;
        }
    }
}

