/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarPresentation;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JList;

public class NavBarListCellRenderer
extends ColoredListCellRenderer {
    private final Project myProject;
    private final NavBarPanel myPanel;

    NavBarListCellRenderer(Project project, NavBarPanel panel) {
        this.myProject = project;
        this.myPanel = panel;
    }

    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        SimpleTextAttributes nameAttributes;
        boolean isProblemFile;
        Color color;
        String name;
        block9: {
            block7: {
                PsiElement psiElement;
                block8: {
                    this.setFocusBorderAroundIcon(false);
                    name = this.myPanel.getPresentation().getPresentableText(value);
                    color = list.getForeground();
                    isProblemFile = false;
                    if (!(value instanceof PsiElement)) break block7;
                    psiElement = (PsiElement)value;
                    PsiFile psiFile = psiElement.getContainingFile();
                    if (psiFile == null) break block8;
                    VirtualFile vFile = psiFile.getVirtualFile();
                    if (vFile == null) break block9;
                    if (WolfTheProblemSolver.getInstance((Project)this.myProject).isProblemFile(vFile)) {
                        isProblemFile = true;
                    }
                    FileStatus status = FileStatusManager.getInstance((Project)this.myProject).getStatus(vFile);
                    color = status.getColor();
                    break block9;
                }
                isProblemFile = NavBarPresentation.wolfHasProblemFilesBeneath(psiElement);
                break block9;
            }
            if (value instanceof Module) {
                Module module = (Module)value;
                isProblemFile = WolfTheProblemSolver.getInstance((Project)this.myProject).hasProblemFilesBeneath(module);
            } else if (value instanceof Project) {
                Module[] modules;
                for (Module module : modules = ModuleManager.getInstance((Project)((Project)value)).getModules()) {
                    if (!WolfTheProblemSolver.getInstance((Project)this.myProject).hasProblemFilesBeneath(module)) continue;
                    isProblemFile = true;
                    break;
                }
            }
        }
        if (isProblemFile) {
            TextAttributes attributes = new TextAttributes(color, null, (Color)JBColor.RED, EffectType.WAVE_UNDERSCORE, 0);
            nameAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes);
        } else {
            nameAttributes = new SimpleTextAttributes(0, color);
        }
        this.append(name, nameAttributes);
        this.setIconOpaque(false);
        this.setIcon(this.myPanel.getPresentation().getIcon(value));
        this.setPaintFocusBorder(false);
        this.setBackground(selected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
    }
}

