/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.IdeView;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class NavBarIdeView
implements IdeView {
    private final NavBarPanel myPanel;

    public NavBarIdeView(NavBarPanel panel) {
        this.myPanel = panel;
    }

    public void selectElement(PsiElement element) {
        Navigatable navigatable;
        this.myPanel.getModel().updateModel(element);
        if (element instanceof Navigatable && (navigatable = (Navigatable)element).canNavigate()) {
            ((Navigatable)element).navigate(true);
        }
        this.myPanel.hideHint();
    }

    @NotNull
    public PsiDirectory[] getDirectories() {
        PsiFile file;
        PsiDirectory dir = this.myPanel.getSelectedElement(PsiDirectory.class);
        if (dir != null && dir.isValid()) {
            PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{dir};
            if (psiDirectoryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarIdeView", "getDirectories"));
            }
            return psiDirectoryArray;
        }
        PsiElement element = this.myPanel.getSelectedElement(PsiElement.class);
        if (element != null && element.isValid() && (file = element.getContainingFile()) != null) {
            PsiDirectory[] psiDirectoryArray;
            PsiDirectory psiDirectory = file.getContainingDirectory();
            if (psiDirectory != null) {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = psiDirectory;
            } else {
                psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
            }
            if (psiDirectoryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarIdeView", "getDirectories"));
            }
            return psiDirectoryArray;
        }
        PsiDirectoryContainer directoryContainer = this.myPanel.getSelectedElement(PsiDirectoryContainer.class);
        if (directoryContainer != null) {
            PsiDirectory[] psiDirectoryArray = directoryContainer.getDirectories();
            if (psiDirectoryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarIdeView", "getDirectories"));
            }
            return psiDirectoryArray;
        }
        Module module = this.myPanel.getSelectedElement(Module.class);
        if (module != null && !module.isDisposed()) {
            ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
            PsiManager psiManager = PsiManager.getInstance((Project)this.myPanel.getProject());
            for (VirtualFile virtualFile : sourceRoots) {
                PsiDirectory directory = psiManager.findDirectory(virtualFile);
                if (directory == null || !directory.isValid()) continue;
                dirs.add(directory);
            }
            PsiDirectory[] psiDirectoryArray = dirs.toArray(new PsiDirectory[dirs.size()]);
            if (psiDirectoryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarIdeView", "getDirectories"));
            }
            return psiDirectoryArray;
        }
        if (PsiDirectory.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarIdeView", "getDirectories"));
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    public PsiDirectory getOrChooseDirectory() {
        return DirectoryChooserUtil.getOrChooseDirectory(this);
    }
}

