/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.annotations.Nullable;

public abstract class EditorMacro
extends Macro {
    private final String myName;
    private final String myDescription;

    public EditorMacro(String name, String description) {
        this.myName = name;
        this.myDescription = description;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public final String expand(DataContext dataContext) throws Macro.ExecutionCancelledException {
        Editor editor;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        if (ToolWindowManager.getInstance((Project)project).isEditorComponentActive() && (editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null) {
            return this.expand(editor);
        }
        return null;
    }

    protected static String getColumnNumber(Editor editor, LogicalPosition pos) {
        if (EditorUtil.inVirtualSpace(editor, pos)) {
            return String.valueOf(pos.column + 1);
        }
        int offset = editor.logicalPositionToOffset(pos);
        int lineStart = editor.getDocument().getLineStartOffset(editor.getDocument().getLineNumber(offset));
        return String.valueOf(offset - lineStart + 1);
    }

    @Nullable
    protected abstract String expand(Editor var1);
}

