/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyNodeRenderer;
import com.intellij.ide.hierarchy.HierarchyTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyBrowserBase
extends SimpleToolWindowPanel
implements HierarchyBrowser,
Disposable,
DataProvider {
    private static final HierarchyNodeDescriptor[] EMPTY_DESCRIPTORS = new HierarchyNodeDescriptor[0];
    protected Content myContent;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    protected final Project myProject;

    protected HierarchyBrowserBase(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/hierarchy/HierarchyBrowserBase", "<init>"));
        }
        super(true, true);
        this.myProject = project;
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return HierarchyBrowserManager.getInstance((Project)HierarchyBrowserBase.this.myProject).getState().IS_AUTOSCROLL_TO_SOURCE;
            }

            protected void setAutoScrollMode(boolean state2) {
                HierarchyBrowserManager.getInstance((Project)HierarchyBrowserBase.this.myProject).getState().IS_AUTOSCROLL_TO_SOURCE = state2;
            }
        };
    }

    public void setContent(Content content) {
        this.myContent = content;
    }

    protected void buildUi(JComponent toolbar, JComponent content) {
        this.setToolbar(toolbar);
        this.setContent(content);
    }

    public void dispose() {
    }

    protected ActionToolbar createToolbar(String place, String helpID) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        this.appendActions(actionGroup, helpID);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(place, (ActionGroup)actionGroup, true);
        actionToolbar.setTargetComponent((JComponent)((Object)this));
        return actionToolbar;
    }

    protected void appendActions(@NotNull DefaultActionGroup actionGroup, @Nullable String helpID) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ide/hierarchy/HierarchyBrowserBase", "appendActions"));
        }
        actionGroup.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        actionGroup.add(ActionManager.getInstance().getAction("ExpandAll"));
        actionGroup.add((AnAction)new PinToolwindowTabAction(){

            @Override
            public void update(AnActionEvent event) {
                super.update(event);
                event.getPresentation().setVisible(HierarchyBrowserBase.this.myContent != null);
            }
        });
        actionGroup.add((AnAction)new CloseAction());
        if (helpID != null) {
            actionGroup.add((AnAction)new ContextHelpAction(helpID));
        }
    }

    protected abstract JTree getCurrentTree();

    protected abstract HierarchyTreeBuilder getCurrentBuilder();

    @Nullable
    protected abstract PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor var1);

    @Nullable
    protected DefaultMutableTreeNode getSelectedNode() {
        JTree tree = this.getCurrentTree();
        if (tree == null) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return (DefaultMutableTreeNode)lastPathComponent;
    }

    @Nullable
    protected final PsiElement getSelectedElement() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        HierarchyNodeDescriptor descriptor = node != null ? this.getDescriptor(node) : null;
        return descriptor != null ? this.getElementFromDescriptor(descriptor) : null;
    }

    @Nullable
    protected HierarchyNodeDescriptor getDescriptor(DefaultMutableTreeNode node) {
        Object userObject;
        Object object = userObject = node != null ? node.getUserObject() : null;
        if (userObject instanceof HierarchyNodeDescriptor) {
            return (HierarchyNodeDescriptor)((Object)userObject);
        }
        return null;
    }

    public final HierarchyNodeDescriptor[] getSelectedDescriptors() {
        JTree tree = this.getCurrentTree();
        if (tree == null) {
            return EMPTY_DESCRIPTORS;
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return EMPTY_DESCRIPTORS;
        }
        ArrayList<HierarchyNodeDescriptor> list = new ArrayList<HierarchyNodeDescriptor>(paths.length);
        for (TreePath path : paths) {
            DefaultMutableTreeNode node;
            HierarchyNodeDescriptor descriptor;
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode) || (descriptor = this.getDescriptor(node = (DefaultMutableTreeNode)lastPathComponent)) == null) continue;
            list.add(descriptor);
        }
        return list.toArray(new HierarchyNodeDescriptor[list.size()]);
    }

    @NotNull
    protected PsiElement[] getSelectedElements() {
        HierarchyNodeDescriptor[] descriptors = this.getSelectedDescriptors();
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (HierarchyNodeDescriptor descriptor : descriptors) {
            PsiElement element = this.getElementFromDescriptor(descriptor);
            if (element == null) continue;
            elements.add(element);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(elements);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/HierarchyBrowserBase", "getSelectedElements"));
        }
        return psiElementArray;
    }

    private Navigatable[] getNavigatables() {
        HierarchyNodeDescriptor[] selectedDescriptors = this.getSelectedDescriptors();
        if (selectedDescriptors == null || selectedDescriptors.length == 0) {
            return null;
        }
        ArrayList<Navigatable> result = new ArrayList<Navigatable>();
        for (HierarchyNodeDescriptor descriptor : selectedDescriptors) {
            Navigatable navigatable = this.getNavigatable(descriptor);
            if (navigatable == null) continue;
            result.add(navigatable);
        }
        return result.toArray(new Navigatable[result.size()]);
    }

    private Navigatable getNavigatable(HierarchyNodeDescriptor descriptor) {
        if (descriptor instanceof Navigatable && descriptor.isValid()) {
            return (Navigatable)descriptor;
        }
        PsiElement element = this.getElementFromDescriptor(descriptor);
        if (element instanceof NavigatablePsiElement && element.isValid()) {
            return (NavigatablePsiElement)element;
        }
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        JTree tree;
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement anElement = this.getSelectedElement();
            return anElement != null && anElement.isValid() ? anElement : super.getData(dataId);
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return this.getSelectedElements();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            DefaultMutableTreeNode selectedNode = this.getSelectedNode();
            if (selectedNode == null) {
                return null;
            }
            HierarchyNodeDescriptor descriptor = this.getDescriptor(selectedNode);
            if (descriptor == null) {
                return null;
            }
            return this.getNavigatable(descriptor);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getNavigatables();
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId) && (tree = this.getCurrentTree()) != null) {
            return new DefaultTreeExpander(tree);
        }
        return super.getData(dataId);
    }

    protected void configureTree(@NotNull Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/hierarchy/HierarchyBrowserBase", "configureTree"));
        }
        tree.getSelectionModel().setSelectionMode(4);
        tree.setToggleClickCount(-1);
        tree.setCellRenderer((TreeCellRenderer)((Object)new HierarchyNodeRenderer()));
        UIUtil.setLineStyleAngled((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        this.myAutoScrollToSourceHandler.install((JTree)tree);
    }

    private final class CloseAction
    extends CloseTabToolbarAction {
        private CloseAction() {
        }

        public final void actionPerformed(AnActionEvent e) {
            ProgressIndicator progress;
            HierarchyTreeBuilder builder = HierarchyBrowserBase.this.getCurrentBuilder();
            AbstractTreeUi treeUi = builder != null ? builder.getUi() : null;
            ProgressIndicator progressIndicator = progress = treeUi != null ? treeUi.getProgress() : null;
            if (progress != null) {
                progress.cancel();
            }
            HierarchyBrowserBase.this.myContent.getManager().removeContent(HierarchyBrowserBase.this.myContent, true);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(HierarchyBrowserBase.this.myContent != null);
        }
    }
}

