/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public class RenameFavoritesListAction
extends AnAction
implements DumbAware {
    public RenameFavoritesListAction() {
        super(IdeBundle.message((String)"action.rename.favorites.list", (Object[])new Object[0]), IdeBundle.message((String)"action.rename.favorites.list", (Object[])new Object[0]), AllIcons.Actions.Menu_replace);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        if (listName == null || favoritesManager.getListProvider(listName) != null) {
            return;
        }
        favoritesManager.renameList(project, listName);
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        e.getPresentation().setEnabled(listName != null && favoritesManager.getListProvider(listName) == null);
    }
}

